/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.testing.ArtifactStubFactory;
import org.apache.maven.plugins.enforcer.BannedDependencies;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.project.MavenProject;

public class BannedDependenciesTestSetup {
    private List<String> excludes = new ArrayList<String>();
    private List<String> includes = new ArrayList<String>();
    private BannedDependencies rule;
    private EnforcerRuleHelper helper;

    public BannedDependenciesTestSetup() throws IOException {
        ArtifactStubFactory factory = new ArtifactStubFactory();
        MockProject project = new MockProject();
        project.setArtifacts(factory.getMixedArtifacts());
        project.setDependencyArtifacts(factory.getScopedArtifacts());
        this.helper = EnforcerTestUtils.getHelper(project);
        this.rule = this.newBannedDependenciesRule();
        this.rule.setMessage(null);
        this.rule.setExcludes(this.excludes);
        this.rule.setIncludes(this.includes);
    }

    public void setSearchTransitive(boolean searchTransitive) {
        this.rule.setSearchTransitive(searchTransitive);
    }

    public void addExcludeAndRunRule(String toAdd) throws EnforcerRuleException {
        this.excludes.add(toAdd);
        this.rule.execute(this.helper);
    }

    public void addIncludeExcludeAndRunRule(String incAdd, String excAdd) throws EnforcerRuleException {
        this.excludes.add(excAdd);
        this.includes.add(incAdd);
        this.rule.execute(this.helper);
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    private BannedDependencies newBannedDependenciesRule() {
        BannedDependencies rule = new BannedDependencies(){

            protected Set<Artifact> getDependenciesToCheck(MavenProject project) {
                return this.isSearchTransitive() ? project.getArtifacts() : project.getDependencyArtifacts();
            }
        };
        return rule;
    }
}

