/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Properties;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.enforcer.DefaultEnforcementRuleHelper;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.plugins.enforcer.utils.MockEnforcerExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.mockito.Mockito;
import org.sonatype.aether.RepositorySystemSession;

public final class EnforcerTestUtils {
    public static MavenSession getMavenSession() {
        PlexusContainer mock = (PlexusContainer)Mockito.mock(PlexusContainer.class);
        MavenExecutionRequest mer = (MavenExecutionRequest)Mockito.mock(MavenExecutionRequest.class);
        Properties systemProperties = new Properties();
        systemProperties.put("maven.version", "3.0");
        Mockito.when((Object)mer.getUserProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)mer.getSystemProperties()).thenReturn((Object)systemProperties);
        MavenExecutionResult meresult = (MavenExecutionResult)Mockito.mock(MavenExecutionResult.class);
        return new MavenSession(mock, (RepositorySystemSession)null, mer, meresult);
    }

    public static EnforcerRuleHelper getHelper() {
        return EnforcerTestUtils.getHelper((MavenProject)new MockProject(), false);
    }

    public static EnforcerRuleHelper getHelper(boolean mockExpression) {
        return EnforcerTestUtils.getHelper((MavenProject)new MockProject(), mockExpression);
    }

    public static EnforcerRuleHelper getHelper(MavenProject project) {
        return EnforcerTestUtils.getHelper(project, false);
    }

    public static EnforcerRuleHelper getHelper(MavenProject project, boolean mockExpression) {
        MockEnforcerExpressionEvaluator eval;
        MavenSession session = EnforcerTestUtils.getMavenSession();
        if (mockExpression) {
            eval = new MockEnforcerExpressionEvaluator(session);
        } else {
            MojoExecution mockExecution = (MojoExecution)Mockito.mock(MojoExecution.class);
            session.setCurrentProject(project);
            eval = new PluginParameterExpressionEvaluator(session, mockExecution);
        }
        return new DefaultEnforcementRuleHelper(session, (ExpressionEvaluator)eval, (Log)new SystemStreamLog(), null);
    }

    public static EnforcerRuleHelper getHelper(MavenProject project, ExpressionEvaluator eval) {
        MavenSession session = EnforcerTestUtils.getMavenSession();
        return new DefaultEnforcementRuleHelper(session, eval, (Log)new SystemStreamLog(), null);
    }

    public static Plugin newPlugin(String groupId, String artifactId, String version) {
        Plugin plugin = new Plugin();
        plugin.setArtifactId(artifactId);
        plugin.setGroupId(groupId);
        plugin.setVersion(version);
        return plugin;
    }
}

