/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.ReactorModuleConvergence;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ReactorModuleConvergenceTest {
    private MavenSession session;
    private EnforcerRuleHelper helper;
    private ReactorModuleConvergence rule;

    @Before
    public void before() throws ExpressionEvaluationException {
        this.session = (MavenSession)Mockito.mock(MavenSession.class);
        this.helper = (EnforcerRuleHelper)Mockito.mock(EnforcerRuleHelper.class);
        Mockito.when((Object)this.helper.evaluate("${session}")).thenReturn((Object)this.session);
        Mockito.when((Object)this.helper.getLog()).thenReturn(Mockito.mock(Log.class));
        this.rule = new ReactorModuleConvergence();
    }

    private void setupSortedProjects(List<MavenProject> projectList) {
        ProjectDependencyGraph pdg = (ProjectDependencyGraph)Mockito.mock(ProjectDependencyGraph.class);
        Mockito.when((Object)this.session.getProjectDependencyGraph()).thenReturn((Object)pdg);
        Mockito.when((Object)pdg.getSortedProjects()).thenReturn(projectList);
    }

    @Test
    public void shouldNotFailWithNoProject() throws EnforcerRuleException {
        this.setupSortedProjects(Collections.<MavenProject>emptyList());
        this.rule.execute(this.helper);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void shouldNotFailWithAValidProject() throws EnforcerRuleException, ExpressionEvaluationException {
        MavenProject mp1 = this.createProjectParent();
        MavenProject mp2 = this.createProjectChild1(mp1);
        MavenProject mp3 = this.createProjectChild2(mp1);
        List<MavenProject> theList = Arrays.asList(mp1, mp2, mp3);
        this.setupSortedProjects(theList);
        this.rule.execute(this.helper);
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=EnforcerRuleException.class)
    public void shouldFailWithWrongVersionInOneChild() throws EnforcerRuleException, ExpressionEvaluationException {
        MavenProject mp1 = this.createProjectParent();
        MavenProject mp2 = this.createProjectChild1(mp1);
        MavenProject mp3 = this.createProjectChild2WithWrongVersion(mp1);
        List<MavenProject> theList = Arrays.asList(mp1, mp2, mp3);
        this.setupSortedProjects(theList);
        this.rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void shouldFailWithWrongParent() throws EnforcerRuleException, ExpressionEvaluationException {
        MavenProject mp1 = this.createProjectParent();
        MavenProject wrongParentVerison = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)wrongParentVerison.getGroupId()).thenReturn((Object)"org.apache.enforcer");
        Mockito.when((Object)wrongParentVerison.getArtifactId()).thenReturn((Object)"m1");
        Mockito.when((Object)wrongParentVerison.getVersion()).thenReturn((Object)"1.1-SNAPSHOT");
        Mockito.when((Object)wrongParentVerison.getId()).thenReturn((Object)"org.apache.enforcer:m1:jar:1.1-SNAPSHOT");
        Mockito.when((Object)wrongParentVerison.getDependencies()).thenReturn(Collections.emptyList());
        MavenProject mp2 = this.createProjectChild2(wrongParentVerison);
        MavenProject mp3 = this.createProjectChild2(mp1);
        List<MavenProject> theList = Arrays.asList(mp1, mp2, mp3);
        this.setupSortedProjects(theList);
        this.rule.execute(this.helper);
    }

    @Test
    public void shouldNotFailWithACompanyParent() throws EnforcerRuleException, ExpressionEvaluationException {
        MavenProject companyParent = this.createCompanyParent();
        MavenProject mp1 = this.createProjectParent(companyParent);
        MavenProject mp2 = this.createProjectChild1(mp1);
        MavenProject mp3 = this.createProjectChild2(mp1);
        List<MavenProject> theList = Arrays.asList(mp1, mp2, mp3);
        this.setupSortedProjects(theList);
        this.rule.execute(this.helper);
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=EnforcerRuleException.class)
    public void shouldFailWithMissingParentsInReactory() throws EnforcerRuleException, ExpressionEvaluationException {
        MavenProject mp1 = this.createProjectParent();
        MavenProject mp2 = this.createProjectChild1(mp1);
        MavenProject mp3 = this.createProjectChild2(null);
        List<MavenProject> theList = Arrays.asList(mp1, mp2, mp3);
        this.setupSortedProjects(theList);
        this.rule.execute(this.helper);
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=EnforcerRuleException.class)
    public void shouldFailWithAParentWhichIsNotPartOfTheReactory() throws EnforcerRuleException, ExpressionEvaluationException {
        MavenProject mp1 = this.createProjectParent();
        MavenProject wrongParentVerison = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)wrongParentVerison.getGroupId()).thenReturn((Object)"org.apache");
        Mockito.when((Object)wrongParentVerison.getArtifactId()).thenReturn((Object)"m1");
        Mockito.when((Object)wrongParentVerison.getVersion()).thenReturn((Object)"1.0-SNAPSHOT");
        Mockito.when((Object)wrongParentVerison.getId()).thenReturn((Object)"org.apache.enforcer:m1:jar:1.0-SNAPSHOT");
        Mockito.when((Object)wrongParentVerison.getDependencies()).thenReturn(Collections.emptyList());
        MavenProject mp2 = this.createProjectChild2(wrongParentVerison);
        MavenProject mp3 = this.createProjectChild2(mp1);
        List<MavenProject> theList = Arrays.asList(mp1, mp2, mp3);
        this.setupSortedProjects(theList);
        this.rule.execute(this.helper);
    }

    @Test
    public void shouldNotFailWithDependencyInReactory() throws EnforcerRuleException, ExpressionEvaluationException {
        MavenProject mp1 = this.createProjectParent();
        MavenProject mp2 = this.createProjectChild1(mp1);
        Dependency goodDependency = this.createDependency("org.junit", "junit", "2.0");
        List<Dependency> depListMP2 = Arrays.asList(goodDependency);
        Mockito.when((Object)mp2.getDependencies()).thenReturn(depListMP2);
        MavenProject mp3 = this.createProjectChild2(mp1);
        Dependency dep1_MP3 = this.createDependency("org.apache.commons", "commons-io", "1.0.4");
        List<Dependency> depListMP3 = Arrays.asList(dep1_MP3);
        Mockito.when((Object)mp3.getDependencies()).thenReturn(depListMP3);
        List<MavenProject> theList = Arrays.asList(mp1, mp2, mp3);
        this.setupSortedProjects(theList);
        this.rule.execute(this.helper);
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=EnforcerRuleException.class)
    public void shouldFailWithWrongDependencyInReactor() throws EnforcerRuleException, ExpressionEvaluationException {
        MavenProject mp1 = this.createProjectParent();
        MavenProject mp2 = this.createProjectChild1(mp1);
        Dependency goodDependency = this.createDependency("org.junit", "junit", "2.0");
        Dependency wrongDepFromReactor = this.createDependency("org.apache.enforcer", "m2", "1.1-SNAPSHOT");
        List<Dependency> depList = Arrays.asList(goodDependency, wrongDepFromReactor);
        Mockito.when((Object)mp2.getDependencies()).thenReturn(depList);
        MavenProject mp3 = this.createProjectChild2(mp1);
        List<MavenProject> theList = Arrays.asList(mp1, mp2, mp3);
        this.setupSortedProjects(theList);
        this.rule.execute(this.helper);
    }

    private MavenProject createProjectChild2WithWrongVersion(MavenProject parent) {
        MavenProject mp2 = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)mp2.getParent()).thenReturn((Object)parent);
        Mockito.when((Object)mp2.getGroupId()).thenReturn((Object)"org.apache.enforcer");
        Mockito.when((Object)mp2.getArtifactId()).thenReturn((Object)"m1");
        Mockito.when((Object)mp2.getVersion()).thenReturn((Object)"1.1-SNAPSHOT");
        Mockito.when((Object)mp2.getId()).thenReturn((Object)"org.apache.enforcer:m1:jar:1.1-SNAPSHOT");
        Mockito.when((Object)mp2.getDependencies()).thenReturn(Collections.emptyList());
        return mp2;
    }

    private MavenProject createProjectChild2(MavenProject parent) {
        MavenProject mp3 = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)mp3.getParent()).thenReturn((Object)parent);
        Mockito.when((Object)mp3.getGroupId()).thenReturn((Object)"org.apache.enforcer");
        Mockito.when((Object)mp3.getArtifactId()).thenReturn((Object)"m2");
        Mockito.when((Object)mp3.getVersion()).thenReturn((Object)"1.0-SNAPSHOT");
        Mockito.when((Object)mp3.getId()).thenReturn((Object)"org.apache.enforcer:m2:jar:1.0-SNAPSHOT");
        Mockito.when((Object)mp3.getDependencies()).thenReturn(Collections.emptyList());
        return mp3;
    }

    private MavenProject createProjectChild1(MavenProject parent) {
        MavenProject mp2 = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)mp2.getParent()).thenReturn((Object)parent);
        Mockito.when((Object)mp2.getGroupId()).thenReturn((Object)"org.apache.enforcer");
        Mockito.when((Object)mp2.getArtifactId()).thenReturn((Object)"m1");
        Mockito.when((Object)mp2.getVersion()).thenReturn((Object)"1.0-SNAPSHOT");
        Mockito.when((Object)mp2.getId()).thenReturn((Object)"org.apache.enforcer:m1:jar:1.0-SNAPSHOT");
        Mockito.when((Object)mp2.getDependencies()).thenReturn(Collections.emptyList());
        return mp2;
    }

    private MavenProject createCompanyParent() {
        MavenProject nonReactorParent = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)nonReactorParent.getGroupId()).thenReturn((Object)"org.apache.enforcer.parent");
        Mockito.when((Object)nonReactorParent.getArtifactId()).thenReturn((Object)"parent");
        Mockito.when((Object)nonReactorParent.getVersion()).thenReturn((Object)"1.1");
        Mockito.when((Object)nonReactorParent.getId()).thenReturn((Object)"org.apache.enforcer.parent:parent:jar:1.1");
        Mockito.when((Object)nonReactorParent.getDependencies()).thenReturn(Collections.emptyList());
        return nonReactorParent;
    }

    private MavenProject createProjectParent(MavenProject nonReactorParent) {
        MavenProject m = this.createProjectParent();
        Mockito.when((Object)m.isExecutionRoot()).thenReturn((Object)true);
        Mockito.when((Object)m.getParent()).thenReturn((Object)nonReactorParent);
        return m;
    }

    private MavenProject createProjectParent() {
        MavenProject mp1 = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)mp1.isExecutionRoot()).thenReturn((Object)true);
        Mockito.when((Object)mp1.getParent()).thenReturn(null);
        Mockito.when((Object)mp1.getGroupId()).thenReturn((Object)"org.apache.enforcer");
        Mockito.when((Object)mp1.getArtifactId()).thenReturn((Object)"parent");
        Mockito.when((Object)mp1.getVersion()).thenReturn((Object)"1.0-SNAPSHOT");
        Mockito.when((Object)mp1.getId()).thenReturn((Object)"org.apache.enforcer:parent:pom:1.0-SNAPSHOT");
        Mockito.when((Object)mp1.getDependencies()).thenReturn(Collections.emptyList());
        return mp1;
    }

    private Dependency createDependency(String groupId, String artifactId, String version) {
        Dependency dep = (Dependency)Mockito.mock(Dependency.class);
        Mockito.when((Object)dep.getGroupId()).thenReturn((Object)groupId);
        Mockito.when((Object)dep.getArtifactId()).thenReturn((Object)artifactId);
        Mockito.when((Object)dep.getVersion()).thenReturn((Object)version);
        return dep;
    }
}

