/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Profile;
import org.apache.maven.plugins.enforcer.RequireActiveProfile;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RequireActiveProfileTest {
    private MavenProject project;
    private EnforcerRuleHelper helper;
    private RequireActiveProfile rule;

    @Before
    public void before() throws ExpressionEvaluationException {
        this.project = (MavenProject)Mockito.mock(MavenProject.class);
        this.helper = (EnforcerRuleHelper)Mockito.mock(EnforcerRuleHelper.class);
        Mockito.when((Object)this.helper.evaluate("${project}")).thenReturn((Object)this.project);
        this.rule = new RequireActiveProfile();
    }

    @Test
    public void testNoActiveProfilesInProjectAndNoProfilesExpectedToBeActivated() throws EnforcerRuleException {
        Mockito.when((Object)this.project.getActiveProfiles()).thenReturn(Collections.emptyList());
        this.rule.execute(this.helper);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testActiveProfileAndExpectedActiveProfile() throws EnforcerRuleException {
        List<Profile> profiles = Collections.singletonList(this.createProfile("profile-2"));
        Mockito.when((Object)this.project.getActiveProfiles()).thenReturn(profiles);
        this.rule.setProfiles("profile-2");
        this.rule.execute(this.helper);
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testNoActiveProfileButTheRuleRequestedAnActiveProfile() throws EnforcerRuleException {
        Mockito.when((Object)this.project.getActiveProfiles()).thenReturn(Collections.emptyList());
        this.rule.setProfiles("profile-2");
        this.rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testNoActiveProfileButWeExpectToGetAnExceptionWithAll() throws EnforcerRuleException {
        Mockito.when((Object)this.project.getActiveProfiles()).thenReturn(Collections.emptyList());
        this.rule.setProfiles("profile-2");
        this.rule.setAll(true);
        this.rule.execute(this.helper);
    }

    @Test
    public void testTwoActiveProfilesWithOneRequiredProfile() throws EnforcerRuleException {
        List<Profile> profiles = Arrays.asList(this.createProfile("profile-1"), this.createProfile("profile-2"));
        Mockito.when((Object)this.project.getActiveProfiles()).thenReturn(profiles);
        this.rule.setProfiles("profile-2");
        this.rule.execute(this.helper);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testTwoActiveProfilesWhereOneProfileIsRequiredToBeActivated() throws EnforcerRuleException {
        List<Profile> profiles = Arrays.asList(this.createProfile("profile-1"), this.createProfile("profile-2"));
        Mockito.when((Object)this.project.getActiveProfiles()).thenReturn(profiles);
        this.rule.setProfiles("profile-2");
        this.rule.setAll(true);
        this.rule.execute(this.helper);
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testTwoActiveProfilesWithTwoRequiredProfilesWhereOneOfThemIsNotPartOfTheActiveProfiles() throws EnforcerRuleException, ExpressionEvaluationException {
        List<Profile> profiles = Arrays.asList(this.createProfile("profile-X"), this.createProfile("profile-Y"));
        Mockito.when((Object)this.project.getActiveProfiles()).thenReturn(profiles);
        this.rule.setProfiles("profile-Z,profile-X");
        this.rule.setAll(true);
        this.rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testOneActiveProfilesWithTwoRequiredProfiles() throws EnforcerRuleException, ExpressionEvaluationException {
        List<Profile> profiles = Collections.singletonList(this.createProfile("profile-X"));
        Mockito.when((Object)this.project.getActiveProfiles()).thenReturn(profiles);
        this.rule.setProfiles("profile-X,profile-Y");
        this.rule.setAll(true);
        this.rule.execute(this.helper);
    }

    @Test
    public void testOneActiveProfileWithTwoProfilesButNotAll() throws EnforcerRuleException, ExpressionEvaluationException {
        List<Profile> profiles = Collections.singletonList(this.createProfile("profile-X"));
        Mockito.when((Object)this.project.getActiveProfiles()).thenReturn(profiles);
        this.rule.setProfiles("profile-X,profile-Y");
        this.rule.setAll(false);
        this.rule.execute(this.helper);
    }

    private Profile createProfile(String profileId) {
        Profile p = new Profile();
        p.setId(profileId);
        return p;
    }
}

