/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Collections;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.RequirePrerequisite;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RequirePrerequisiteTest {
    private MavenProject project;
    private EnforcerRuleHelper helper;

    @Before
    public void before() throws ExpressionEvaluationException {
        this.project = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)this.project.getPackaging()).thenReturn((Object)"maven-plugin");
        this.helper = (EnforcerRuleHelper)Mockito.mock(EnforcerRuleHelper.class);
        Mockito.when((Object)this.helper.evaluate("${project}")).thenReturn((Object)this.project);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testNoPrerequisite() throws Exception {
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.execute(this.helper);
    }

    @Test
    public void testNoSpecifiedPrerequisite() throws Exception {
        Mockito.when((Object)this.project.getPrerequisites()).thenReturn((Object)new Prerequisites());
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testLowerMavenPrerequisite() throws Exception {
        Mockito.when((Object)this.project.getPrerequisites()).thenReturn((Object)new Prerequisites());
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.setMavenVersion("3.0");
        rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testLowerMavenRangePrerequisite() throws Exception {
        Mockito.when((Object)this.project.getPrerequisites()).thenReturn((Object)new Prerequisites());
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.setMavenVersion("[3.0,)");
        rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testMavenRangesPrerequisite() throws Exception {
        Prerequisites prerequisites = new Prerequisites();
        prerequisites.setMaven("2.2.0");
        Mockito.when((Object)this.project.getPrerequisites()).thenReturn((Object)prerequisites);
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.setMavenVersion("[2.0.6,2.1.0),(2.1.0,2.2.0),(2.2.0,)");
        rule.execute(this.helper);
    }

    @Test
    public void testValidPrerequisite() throws Exception {
        Prerequisites prerequisites = new Prerequisites();
        prerequisites.setMaven("3.0");
        Mockito.when((Object)this.project.getPrerequisites()).thenReturn((Object)prerequisites);
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.setMavenVersion("2.2.1");
        rule.execute(this.helper);
    }

    @Test
    public void testPomPackaging() throws Exception {
        Mockito.when((Object)this.project.getPackaging()).thenReturn((Object)"pom");
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)this.helper.getLog()).thenReturn((Object)log);
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.execute(this.helper);
        ((Log)Mockito.verify((Object)log)).debug((CharSequence)"Packaging is pom, skipping requirePrerequisite rule");
    }

    @Test(expected=EnforcerRuleException.class)
    public void testMatchingPackagings() throws Exception {
        Mockito.when((Object)this.project.getPackaging()).thenReturn((Object)"maven-plugin");
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.setPackagings(Collections.singletonList("maven-plugin"));
        rule.execute(this.helper);
    }

    @Test
    public void testNotMatchingPackagings() throws Exception {
        Mockito.when((Object)this.project.getPackaging()).thenReturn((Object)"jar");
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)this.helper.getLog()).thenReturn((Object)log);
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.setPackagings(Collections.singletonList("maven-plugin"));
        rule.execute(this.helper);
        ((Log)Mockito.verify((Object)log)).debug((CharSequence)"Packaging is jar, skipping requirePrerequisite rule");
    }
}

