/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import junit.framework.TestCase;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.enforcer.AbstractVersionEnforcer;
import org.apache.maven.plugins.enforcer.RequireJavaVersion;
import org.apache.maven.plugins.enforcer.RequireMavenVersion;

public class TestAbstractVersionEnforcer
extends TestCase {
    public void testContainsVersion() throws InvalidVersionSpecificationException {
        DefaultArtifactVersion version = new DefaultArtifactVersion("2.0.5");
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[2.0.5,)"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[2.0.4,)"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[2.0.4,2.0.5]"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[2.0.4,2.0.6]"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[2.0.4,2.0.6)"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[2.0,)"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[2.0.0,)"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertFalse((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[2.0.4,2.0.5)"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertFalse((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[2.0.6,)"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertFalse((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"(2.0.5,)"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"2.0"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"2.0.4"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"2.0.5"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertFalse((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"2.0.6"), (ArtifactVersion)version));
        version = new DefaultArtifactVersion("1.5.0-7");
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[1.5.0,)"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[1.5,1.6)"), (ArtifactVersion)version));
        version = new DefaultArtifactVersion(RequireJavaVersion.normalizeJDKVersion((String)"1.5.0-07"));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[1.5.0,)"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[1.5,1.6)"), (ArtifactVersion)version));
        version = new DefaultArtifactVersion("2.1.0-M1-RC12");
        TestAbstractVersionEnforcer.assertTrue((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[2.1.0-M1-RC12,)"), (ArtifactVersion)version));
        TestAbstractVersionEnforcer.assertFalse((boolean)AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)"[2.1.0-M1,)"), (ArtifactVersion)version));
    }

    private void enforceFalse(AbstractVersionEnforcer rule, Log log, String var, String range, ArtifactVersion version) {
        block2: {
            try {
                rule.enforceVersion(log, var, range, version);
                TestAbstractVersionEnforcer.fail((String)("Expected to receive EnforcerRuleException because:" + version + " is not contained by " + range));
            }
            catch (Exception e) {
                if (e instanceof EnforcerRuleException) break block2;
                TestAbstractVersionEnforcer.fail((String)("Received wrong exception. Expected EnforcerRuleExeption. Received:" + e.toString()));
            }
        }
    }

    public void testEnforceVersion() {
        RequireMavenVersion rule = new RequireMavenVersion();
        DefaultArtifactVersion version = new DefaultArtifactVersion("2.0.5");
        SystemStreamLog log = new SystemStreamLog();
        try {
            rule.enforceVersion((Log)log, "test", "[2.0.5,)", (ArtifactVersion)version);
            rule.enforceVersion((Log)log, "test", "[2.0.4,)", (ArtifactVersion)version);
            rule.enforceVersion((Log)log, "test", "[2.0.4,2.0.5]", (ArtifactVersion)version);
            rule.enforceVersion((Log)log, "test", "[2.0.4,2.0.6]", (ArtifactVersion)version);
            rule.enforceVersion((Log)log, "test", "[2.0.4,2.0.6)", (ArtifactVersion)version);
            rule.enforceVersion((Log)log, "test", "[2.0,)", (ArtifactVersion)version);
            rule.enforceVersion((Log)log, "test", "[2.0.0,)", (ArtifactVersion)version);
            rule.enforceVersion((Log)log, "test", "2.0", (ArtifactVersion)version);
            rule.enforceVersion((Log)log, "test", "2.0.4", (ArtifactVersion)version);
            rule.enforceVersion((Log)log, "test", "2.0.5", (ArtifactVersion)version);
        }
        catch (Exception e) {
            TestAbstractVersionEnforcer.fail((String)("No Exception expected. Caught:" + e.getLocalizedMessage()));
        }
        this.enforceFalse((AbstractVersionEnforcer)rule, (Log)log, "test", "[2.0.6,)", (ArtifactVersion)version);
        this.enforceFalse((AbstractVersionEnforcer)rule, (Log)log, "test", "(2.0.5,)", (ArtifactVersion)version);
        this.enforceFalse((AbstractVersionEnforcer)rule, (Log)log, "test", "2.0.6", (ArtifactVersion)version);
        this.enforceFalse((AbstractVersionEnforcer)rule, (Log)log, "test", "[2.0.4,2.0.5)", (ArtifactVersion)version);
        this.enforceFalse((AbstractVersionEnforcer)rule, (Log)log, "test", "[[2.0.4,2.0.5)", (ArtifactVersion)version);
    }
}

