/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.IOException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugins.enforcer.BannedDependenciesTestSetup;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class TestBannedDependencies {

    public static class IncludesExcludesNoTransitive {
        private BannedDependenciesTestSetup setup;

        @Before
        public void beforeMethod() throws IOException {
            this.setup = new BannedDependenciesTestSetup();
            this.setup.setSearchTransitive(false);
        }

        private void addIncludeExcludeAndRunRule(String incAdd, String excAdd) throws EnforcerRuleException {
            this.setup.addIncludeExcludeAndRunRule(incAdd, excAdd);
        }

        @Test
        public void includeEverythingAndExcludeEverythign() throws EnforcerRuleException {
            this.addIncludeExcludeAndRunRule("*", "*");
        }

        @Test
        public void includeEverythingAndExcludeEveryGroupIdAndScopeRuntime() throws EnforcerRuleException {
            this.addIncludeExcludeAndRunRule("*", "*:runtime");
        }

        @Test(expected=EnforcerRuleException.class)
        public void includeEverythingAndExcludeEveryGroupIdAndScopeRuntimeYYYY() throws EnforcerRuleException {
            this.addIncludeExcludeAndRunRule("*:test", "*:runtime");
        }
    }

    public static class IllegalFormatsTests {
        private BannedDependenciesTestSetup setup;

        @Before
        public void beforeMethod() throws IOException {
            this.setup = new BannedDependenciesTestSetup();
            this.setup.setSearchTransitive(true);
        }

        private void addExcludeAndRunRule(String toAdd) throws EnforcerRuleException {
            this.setup.addExcludeAndRunRule(toAdd);
        }

        @Test(expected=IllegalArgumentException.class)
        public void onlyThreeColonsWithoutAnythingElse() throws EnforcerRuleException {
            this.addExcludeAndRunRule(":::");
        }

        @Test(expected=IllegalArgumentException.class)
        public void onlySevenColonsWithoutAnythingElse() throws EnforcerRuleException {
            this.addExcludeAndRunRule(":::::::");
        }
    }

    public static class PartialWildcardExcludesUsingTransitiveDependencies {
        private BannedDependenciesTestSetup setup;

        @Before
        public void beforeMethod() throws IOException {
            this.setup = new BannedDependenciesTestSetup();
            this.setup.setSearchTransitive(true);
        }

        private void addExcludeAndRunRule(String toAdd) throws EnforcerRuleException {
            this.setup.addExcludeAndRunRule(toAdd);
        }

        @Test(expected=EnforcerRuleException.class)
        public void groupIdArtifactIdWithWildcard() throws EnforcerRuleException {
            this.addExcludeAndRunRule("testGroupId:re*");
        }

        @Test(expected=EnforcerRuleException.class)
        public void groupIdArtifactIdVersionTypeWildcardScope() throws EnforcerRuleException {
            this.addExcludeAndRunRule("g:a:1.0:war:co*");
        }

        @Test(expected=EnforcerRuleException.class)
        public void groupIdArtifactIdVersionWildcardTypeScope() throws EnforcerRuleException {
            this.addExcludeAndRunRule("g:a:1.0:w*:compile");
        }
    }

    public static class WildcardExcludesUsingTransitiveDependencies {
        private BannedDependenciesTestSetup setup;

        @Before
        public void beforeMethod() throws IOException {
            this.setup = new BannedDependenciesTestSetup();
            this.setup.setSearchTransitive(true);
        }

        private void addExcludeAndRunRule(String toAdd) throws EnforcerRuleException {
            this.setup.addExcludeAndRunRule(toAdd);
        }

        @Test
        public void testWildcardForGroupIdArtifactIdVersion() throws Exception {
            this.addExcludeAndRunRule("*:release:1.2");
        }

        @Test(expected=EnforcerRuleException.class)
        public void testWildCardForGroupIdArtifactId() throws Exception {
            this.addExcludeAndRunRule("*:release");
        }

        @Test(expected=EnforcerRuleException.class)
        public void testWildcardForGroupIdWildcardForArtifactIdVersion() throws Exception {
            this.addExcludeAndRunRule("*:*:1.0");
        }

        @Test(expected=EnforcerRuleException.class)
        public void testWildcardForGroupIdArtifactIdWildcardForVersion() throws Exception {
            this.addExcludeAndRunRule("*:release:*");
        }
    }

    public static class ExcludesUsingTransitiveDependencies {
        private BannedDependenciesTestSetup setup;

        @Before
        public void beforeMethod() throws IOException {
            this.setup = new BannedDependenciesTestSetup();
            this.setup.setSearchTransitive(true);
        }

        private void addExcludeAndRunRule(String toAdd) throws EnforcerRuleException {
            this.setup.addExcludeAndRunRule(toAdd);
        }

        @Test(expected=EnforcerRuleException.class)
        public void testGroupIdArtifactIdVersion() throws Exception {
            this.addExcludeAndRunRule("testGroupId:release:1.0");
        }

        @Test(expected=EnforcerRuleException.class)
        public void testGroupIdArtifactId() throws Exception {
            this.addExcludeAndRunRule("testGroupId:release");
        }

        @Test(expected=EnforcerRuleException.class)
        public void testGroupId() throws Exception {
            this.addExcludeAndRunRule("testGroupId");
        }

        @Test(expected=EnforcerRuleException.class)
        public void testSpaceTrimmingGroupIdArtifactIdVersion() throws Exception {
            this.addExcludeAndRunRule("  testGroupId  :  release   :   1.0    ");
        }

        @Test(expected=EnforcerRuleException.class)
        public void groupIdArtifactIdVersionType() throws Exception {
            this.addExcludeAndRunRule("g:a:1.0:war");
        }

        @Test(expected=EnforcerRuleException.class)
        public void groupIdArtifactIdVersionTypeScope() throws Exception {
            this.addExcludeAndRunRule("g:a:1.0:war:compile");
        }
    }

    public static class ExcludesDoNotUseTransitiveDependencies {
        private BannedDependenciesTestSetup setup;

        @Before
        public void beforeMethod() throws IOException {
            this.setup = new BannedDependenciesTestSetup();
            this.setup.setSearchTransitive(false);
        }

        private void addExcludeAndRunRule(String toAdd) throws EnforcerRuleException {
            this.setup.addExcludeAndRunRule(toAdd);
        }

        @Test
        public void testGroupIdArtifactIdVersion() throws Exception {
            this.addExcludeAndRunRule("testGroupId:release:1.0");
        }

        @Test
        public void testGroupIdArtifactId() throws Exception {
            this.addExcludeAndRunRule("testGroupId:release");
        }

        @Test
        public void testGroupId() throws Exception {
            this.addExcludeAndRunRule("testGroupId");
        }
    }
}

