/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.BannedRepositories;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.codehaus.plexus.PlexusTestCase;

public class TestBannedRepositories
extends PlexusTestCase {
    private EnforcerRuleHelper helper;
    private BannedRepositories rule;
    private MockProject project;

    public void setUp() throws Exception {
        super.setUp();
        this.rule = new BannedRepositories();
        this.rule.setMessage("my message");
        this.project = new MockProject();
        this.project.setGroupId("org.apache.maven.plugins.enforcer.test");
        this.project.setVersion("1.0-SNAPSHOT");
        this.helper = EnforcerTestUtils.getHelper(this.project);
    }

    public void testNoCheckRules() throws EnforcerRuleException {
        DefaultArtifactRepository repo1 = new DefaultArtifactRepository("repo1", "http://repo1/", null);
        ArrayList<DefaultArtifactRepository> repos = new ArrayList<DefaultArtifactRepository>();
        repos.add(repo1);
        this.project.setRemoteArtifactRepositories(repos);
        this.project.setPluginArtifactRepositories(repos);
        this.rule.execute(this.helper);
    }

    public void testBannedRepositories() {
        DefaultArtifactRepository repo1 = new DefaultArtifactRepository("repo1", "http://repo1/", null);
        DefaultArtifactRepository repo2 = new DefaultArtifactRepository("repo1", "http://repo1/test", null);
        DefaultArtifactRepository repo3 = new DefaultArtifactRepository("repo1", "http://repo2/test", null);
        ArrayList<DefaultArtifactRepository> repos = new ArrayList<DefaultArtifactRepository>();
        repos.add(repo1);
        repos.add(repo2);
        repos.add(repo3);
        this.project.setRemoteArtifactRepositories(repos);
        this.project.setPluginArtifactRepositories(repos);
        ArrayList<String> bannedRepositories = new ArrayList<String>();
        String pattern1 = "http://repo1/*";
        bannedRepositories.add(pattern1);
        this.rule.setBannedRepositories(bannedRepositories);
        try {
            this.rule.execute(this.helper);
            TestBannedRepositories.fail((String)"should throw exception");
        }
        catch (EnforcerRuleException enforcerRuleException) {
            // empty catch block
        }
    }

    public void testAllowedRepositoriesAllOK() throws EnforcerRuleException {
        DefaultArtifactRepository repo1 = new DefaultArtifactRepository("repo1", "http://repo1/", null);
        DefaultArtifactRepository repo2 = new DefaultArtifactRepository("repo1", "http://repo1/test", null);
        ArrayList<DefaultArtifactRepository> repos = new ArrayList<DefaultArtifactRepository>();
        repos.add(repo1);
        repos.add(repo2);
        this.project.setRemoteArtifactRepositories(repos);
        this.project.setPluginArtifactRepositories(repos);
        ArrayList<String> bannedRepositories = new ArrayList<String>();
        String pattern1 = "http://repo1/*";
        bannedRepositories.add(pattern1);
        this.rule.setAllowedRepositories(bannedRepositories);
        this.rule.setAllowedPluginRepositories(bannedRepositories);
        this.rule.execute(this.helper);
    }

    public void testAllowedRepositoriesException() {
        DefaultArtifactRepository repo1 = new DefaultArtifactRepository("repo1", "http://repo1/", null);
        DefaultArtifactRepository repo2 = new DefaultArtifactRepository("repo1", "http://repo1/test", null);
        DefaultArtifactRepository repo3 = new DefaultArtifactRepository("repo1", "http://repo2/test", null);
        ArrayList<DefaultArtifactRepository> repos = new ArrayList<DefaultArtifactRepository>();
        repos.add(repo1);
        repos.add(repo2);
        repos.add(repo3);
        this.project.setRemoteArtifactRepositories(repos);
        this.project.setPluginArtifactRepositories(repos);
        ArrayList<String> patterns = new ArrayList<String>();
        String pattern1 = "http://repo1/*";
        patterns.add(pattern1);
        this.rule.setAllowedPluginRepositories(patterns);
        this.rule.setAllowedRepositories(patterns);
        try {
            this.rule.execute(this.helper);
            TestBannedRepositories.fail((String)"should throw exception");
        }
        catch (EnforcerRuleException enforcerRuleException) {
            // empty catch block
        }
    }
}

