/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import junit.framework.TestCase;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.EvaluateBeanshell;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.mockito.Mockito;

public class TestEvaluateBeanshell
extends TestCase {
    private MockProject project;

    public void setUp() {
        this.project = new MockProject();
        this.project.setProperty("env", "\"This is a test.\"");
    }

    public void testRulePass() throws EnforcerRuleException, ExpressionEvaluationException {
        EvaluateBeanshell rule = new EvaluateBeanshell();
        rule.setCondition("${env} == \"This is a test.\"");
        rule.setMessage("We have a variable : ${env}");
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(this.project);
        rule.execute(helper);
    }

    public void testRuleFail() throws EnforcerRuleException, ExpressionEvaluationException {
        EvaluateBeanshell rule = new EvaluateBeanshell();
        rule.setCondition("${env} == null");
        rule.setMessage("We have a variable : ${env}");
        try {
            EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(this.project);
            rule.execute(helper);
            TestEvaluateBeanshell.fail((String)"Expected an exception.");
        }
        catch (EnforcerRuleException e) {
            TestEvaluateBeanshell.assertEquals((String)e.getLocalizedMessage(), (String)rule.getMessage());
        }
    }

    public void testRuleFailNoMessage() throws EnforcerRuleException, ExpressionEvaluationException {
        EvaluateBeanshell rule = new EvaluateBeanshell();
        rule.setCondition("${env} == null");
        try {
            EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(this.project);
            rule.execute(helper);
            TestEvaluateBeanshell.fail((String)"Expected an exception.");
        }
        catch (EnforcerRuleException e) {
            TestEvaluateBeanshell.assertEquals((String)e.getLocalizedMessage(), (String)"The expression \"${env} == null\" is not true.");
            TestEvaluateBeanshell.assertTrue((e.getLocalizedMessage().length() > 0 ? 1 : 0) != 0);
        }
    }

    public void testRuleInvalidExpression() throws EnforcerRuleException, ExpressionEvaluationException {
        EvaluateBeanshell rule = new EvaluateBeanshell();
        rule.setCondition("${env} == null");
        rule.setMessage("We have a variable : ${env}");
        ExpressionEvaluator eval = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class);
        Mockito.when((Object)eval.evaluate(rule.getCondition())).thenThrow(new Throwable[]{new ExpressionEvaluationException("expected error")});
        try {
            EnforcerRuleHelper helper = EnforcerTestUtils.getHelper((MavenProject)this.project, eval);
            rule.execute(helper);
            TestEvaluateBeanshell.fail((String)"Expected an exception.");
        }
        catch (EnforcerRuleException e) {
            TestEvaluateBeanshell.assertFalse((boolean)e.getLocalizedMessage().equals(rule.getMessage()));
        }
    }

    public void testRuleInvalidBeanshell() throws EnforcerRuleException, ExpressionEvaluationException {
        EvaluateBeanshell rule = new EvaluateBeanshell();
        rule.setCondition("this is not valid beanshell");
        rule.setMessage("We have a variable : ${env}");
        try {
            EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(this.project);
            rule.execute(helper);
            TestEvaluateBeanshell.fail((String)"Expected an exception.");
        }
        catch (EnforcerRuleException e) {
            TestEvaluateBeanshell.assertFalse((boolean)e.getLocalizedMessage().equals(rule.getMessage()));
        }
    }
}

