/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import junit.framework.TestCase;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.plugins.enforcer.RequireEnvironmentVariable;

public class TestRequireEnvironmentVariable
extends TestCase {
    public void testRule() throws EnforcerRuleException {
        MockProject project = new MockProject();
        project.setProperty("testProp", "This is a test.");
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(project);
        RequireEnvironmentVariable rule = new RequireEnvironmentVariable();
        rule.setVariableName("JUNK");
        try {
            rule.execute(helper);
            TestRequireEnvironmentVariable.fail((String)"Expected an exception.");
        }
        catch (EnforcerRuleException enforcerRuleException) {
            // empty catch block
        }
        rule.setVariableName("PATH");
        try {
            rule.execute(helper);
        }
        catch (EnforcerRuleException e) {
            TestRequireEnvironmentVariable.fail((String)"This should not throw an exception");
        }
    }

    public void testRuleWithRegex() throws EnforcerRuleException {
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper();
        RequireEnvironmentVariable rule = new RequireEnvironmentVariable();
        rule.setVariableName("PATH");
        rule.setRegex("[^abc]");
        try {
            rule.execute(helper);
            TestRequireEnvironmentVariable.fail((String)"Expected an exception.");
        }
        catch (EnforcerRuleException enforcerRuleException) {
            // empty catch block
        }
        rule.setRegex(".{1,}");
        try {
            rule.execute(helper);
        }
        catch (EnforcerRuleException e) {
            TestRequireEnvironmentVariable.fail((String)"This should not throw an exception");
        }
    }
}

