/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.RequireFileChecksum;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class TestRequireFileChecksum {
    private RequireFileChecksum rule = new RequireFileChecksum();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testFileChecksumMd5() throws IOException, EnforcerRuleException {
        File f = this.temporaryFolder.newFile();
        FileUtils.fileWrite((File)f, (String)"message");
        this.rule.setFile(f);
        this.rule.setChecksum("78e731027d8fd50ed642340b7c9a63b3");
        this.rule.setType("md5");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    @Test
    public void testFileChecksumMd5UpperCase() throws IOException, EnforcerRuleException {
        File f = this.temporaryFolder.newFile();
        FileUtils.fileWrite((File)f, (String)"message");
        this.rule.setFile(f);
        this.rule.setChecksum("78E731027D8FD50ED642340B7C9A63B3");
        this.rule.setType("md5");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    @Test
    public void testFileChecksumMd5NoFileFailure() throws IOException, EnforcerRuleException {
        File f = new File("foo"){
            private static final long serialVersionUID = 6987790643999338089L;

            @Override
            public boolean canRead() {
                return false;
            }
        };
        this.expectedException.expect(EnforcerRuleException.class);
        this.expectedException.expectMessage("Cannot read file: " + f.getAbsolutePath());
        this.rule.setFile(f);
        this.rule.setChecksum("78e731027d8fd50ed642340b7c9a63b3");
        this.rule.setType("md5");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    @Test
    public void testFileChecksumMd5GivenFileIsADirectoryFailure() throws IOException, EnforcerRuleException {
        File f = this.temporaryFolder.newFolder();
        this.expectedException.expect(EnforcerRuleException.class);
        this.expectedException.expectMessage("Cannot read file: " + f.getAbsolutePath());
        this.rule.setFile(f);
        this.rule.setChecksum("78e731027d8fd50ed642340b7c9a63b3");
        this.rule.setType("md5");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    @Test
    public void testFileChecksumMd5NoFileSpecifiedFailure() throws IOException, EnforcerRuleException {
        this.expectedException.expect(EnforcerRuleException.class);
        this.expectedException.expectMessage("Input file unspecified");
        this.rule.setChecksum("78e731027d8fd50ed642340b7c9a63b3");
        this.rule.setType("md5");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    @Test
    public void testFileChecksumMd5NoChecksumSpecifiedFailure() throws IOException, EnforcerRuleException {
        this.expectedException.expect(EnforcerRuleException.class);
        this.expectedException.expectMessage("Checksum unspecified");
        File f = this.temporaryFolder.newFile();
        this.rule.setFile(f);
        this.rule.setType("md5");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    @Test
    public void testFileChecksumMd5NoTypeSpecifiedFailure() throws IOException, EnforcerRuleException {
        this.expectedException.expect(EnforcerRuleException.class);
        this.expectedException.expectMessage("Hash type unspecified");
        File f = this.temporaryFolder.newFile();
        this.rule.setFile(f);
        this.rule.setChecksum("78e731027d8fd50ed642340b7c9a63b3");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    @Test
    public void testFileChecksumMd5ChecksumMismatchFailure() throws IOException, EnforcerRuleException {
        File f = this.temporaryFolder.newFile();
        FileUtils.fileWrite((File)f, (String)"message");
        this.expectedException.expect(EnforcerRuleException.class);
        this.expectedException.expectMessage("md5 hash of " + f.getAbsolutePath() + " was 78e731027d8fd50ed642340b7c9a63b3 but expected ffeeddccbbaa99887766554433221100");
        this.rule.setFile(f);
        this.rule.setChecksum("ffeeddccbbaa99887766554433221100");
        this.rule.setType("md5");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    @Test
    public void testFileChecksumSha1() throws IOException, EnforcerRuleException {
        File f = this.temporaryFolder.newFile();
        FileUtils.fileWrite((File)f, (String)"message");
        this.rule.setFile(f);
        this.rule.setChecksum("6f9b9af3cd6e8b8a73c2cdced37fe9f59226e27d");
        this.rule.setType("sha1");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    @Test
    public void testFileChecksumSha256() throws IOException, EnforcerRuleException {
        File f = this.temporaryFolder.newFile();
        FileUtils.fileWrite((File)f, (String)"message");
        this.rule.setFile(f);
        this.rule.setChecksum("ab530a13e45914982b79f9b7e3fba994cfd1f3fb22f71cea1afbf02b460c6d1d");
        this.rule.setType("sha256");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    @Test
    public void testFileChecksumSha384() throws IOException, EnforcerRuleException {
        File f = this.temporaryFolder.newFile();
        FileUtils.fileWrite((File)f, (String)"message");
        this.rule.setFile(f);
        this.rule.setChecksum("353eb7516a27ef92e96d1a319712d84b902eaa828819e53a8b09af7028103a9978ba8feb6161e33c3619c5da4c4666a5");
        this.rule.setType("sha384");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    @Test
    public void testFileChecksumSha512() throws IOException, EnforcerRuleException {
        File f = this.temporaryFolder.newFile();
        FileUtils.fileWrite((File)f, (String)"message");
        this.rule.setFile(f);
        this.rule.setChecksum("f8daf57a3347cc4d6b9d575b31fe6077e2cb487f60a96233c08cb479dbf31538cc915ec6d48bdbaa96ddc1a16db4f4f96f37276cfcb3510b8246241770d5952c");
        this.rule.setType("sha512");
        this.rule.execute(EnforcerTestUtils.getHelper());
    }
}

