/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.RequireJavaVersion;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;

public class TestRequireJavaVersion {
    @Test
    public void testFixJDKVersion() {
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.0_11")).isEqualTo((Object)"1.5.0-11");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.1")).isEqualTo((Object)"1.5.1");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.2-1.b11")).isEqualTo((Object)"1.5.2-1");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.3_11")).isEqualTo((Object)"1.5.3-11");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.4.5_11")).isEqualTo((Object)"1.5.4-5");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.5.6_11.2")).isEqualTo((Object)"1.5.5-6");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1-5-0-11")).isEqualTo((Object)"1.5.0-11");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1-_5-_0-_11")).isEqualTo((Object)"1.5.0-11");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1_5_0_11")).isEqualTo((Object)"1.5.0-11");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.0-07")).isEqualTo((Object)"1.5.0-7");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.0-b7")).isEqualTo((Object)"1.5.0-7");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.0-;7")).isEqualTo((Object)"1.5.0-7");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.6.0-dp")).isEqualTo((Object)"1.6.0");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.6.0-dp2")).isEqualTo((Object)"1.6.0-2");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"1.8.0_73")).isEqualTo((Object)"1.8.0-73");
        Assertions.assertThat((String)RequireJavaVersion.normalizeJDKVersion((String)"9")).isEqualTo((Object)"9");
    }

    @Test
    public void settingsTheJavaVersionAsNormalizedVersionShouldNotFail() throws EnforcerRuleException {
        String normalizedJDKVersion = RequireJavaVersion.normalizeJDKVersion((String)SystemUtils.JAVA_VERSION);
        RequireJavaVersion rule = new RequireJavaVersion();
        rule.setVersion(normalizedJDKVersion);
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper();
        rule.execute(helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void excludingTheCurrentJavaVersionViaRangeThisShouldFailWithException() throws EnforcerRuleException {
        String thisVersion = RequireJavaVersion.normalizeJDKVersion((String)SystemUtils.JAVA_VERSION);
        RequireJavaVersion rule = new RequireJavaVersion();
        rule.setVersion("(" + thisVersion);
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper();
        rule.execute(helper);
    }

    @Test
    @Ignore
    public void thisShouldNotCrash() throws EnforcerRuleException {
        RequireJavaVersion rule = new RequireJavaVersion();
        rule.setVersion(SystemUtils.JAVA_VERSION);
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper();
        rule.execute(helper);
    }

    @Test
    public void testId() {
        RequireJavaVersion rule = new RequireJavaVersion();
        Assertions.assertThat((String)rule.getCacheId()).isEqualTo((Object)"0");
    }
}

