/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.RequireNoRepositories;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRequireNoRepositories {
    private EnforcerRuleHelper helper;
    private RequireNoRepositories rule;
    private MavenSession session;

    @Before
    public void before() throws ExpressionEvaluationException {
        this.session = (MavenSession)Mockito.mock(MavenSession.class);
        this.helper = (EnforcerRuleHelper)Mockito.mock(EnforcerRuleHelper.class);
        Mockito.when((Object)this.helper.evaluate("${session}")).thenReturn((Object)this.session);
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)this.helper.getLog()).thenReturn((Object)log);
        this.rule = new RequireNoRepositories();
        this.rule.setMessage("my message");
    }

    private MavenProject createMavenProject() {
        MavenProject mp = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)mp.getGroupId()).thenReturn((Object)"org.apache.maven.plugins.enforcer.test");
        Mockito.when((Object)mp.getArtifactId()).thenReturn((Object)"no-repositories-child");
        Mockito.when((Object)mp.getVersion()).thenReturn((Object)"1.0-SNAPSHOT");
        return mp;
    }

    private Model createOriginalModel() {
        Model m = (Model)Mockito.mock(Model.class);
        Mockito.when((Object)m.getGroupId()).thenReturn((Object)"org.apache.maven.plugins.enforcer.test");
        Mockito.when((Object)m.getArtifactId()).thenReturn((Object)"no-repositories");
        Mockito.when((Object)m.getVersion()).thenReturn((Object)"1.0-SNAPSHOT");
        return m;
    }

    private MavenProject createStandAloneProject() {
        MavenProject mp = this.createMavenProject();
        Model originalModel = this.createOriginalModel();
        Mockito.when((Object)mp.getModel()).thenReturn((Object)originalModel);
        Mockito.when((Object)mp.getOriginalModel()).thenReturn((Object)originalModel);
        return mp;
    }

    private void setupSortedProjects(List<MavenProject> projectList) {
        ProjectDependencyGraph pdg = (ProjectDependencyGraph)Mockito.mock(ProjectDependencyGraph.class);
        Mockito.when((Object)this.session.getProjectDependencyGraph()).thenReturn((Object)pdg);
        Mockito.when((Object)pdg.getSortedProjects()).thenReturn(projectList);
    }

    private Repository createRepository(String id, String url) {
        Repository r = new Repository();
        r.setId(id);
        r.setUrl(url);
        RepositoryPolicy snapshotPolicy = new RepositoryPolicy();
        snapshotPolicy.setEnabled(false);
        snapshotPolicy.setUpdatePolicy("daily");
        r.setSnapshots(snapshotPolicy);
        RepositoryPolicy releasePolicy = new RepositoryPolicy();
        releasePolicy.setEnabled(true);
        releasePolicy.setUpdatePolicy("never");
        r.setReleases(releasePolicy);
        return r;
    }

    private Repository createSnapshotRepository(String id, String url) {
        Repository r = new Repository();
        r.setId(id);
        r.setUrl(url);
        RepositoryPolicy snapshotPolicy = new RepositoryPolicy();
        snapshotPolicy.setEnabled(true);
        snapshotPolicy.setUpdatePolicy("daily");
        r.setSnapshots(snapshotPolicy);
        RepositoryPolicy releasePolicy = new RepositoryPolicy();
        releasePolicy.setEnabled(false);
        r.setReleases(releasePolicy);
        return r;
    }

    private MavenProject addRepository(MavenProject project, Repository r) {
        Model originalModel = project.getOriginalModel();
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        repositories.add(r);
        Mockito.when((Object)originalModel.getRepositories()).thenReturn(repositories);
        return project;
    }

    private MavenProject addEmptyRepository(MavenProject project) {
        Model originalModel = project.getOriginalModel();
        ArrayList repositories = new ArrayList();
        Mockito.when((Object)originalModel.getRepositories()).thenReturn(repositories);
        return project;
    }

    private MavenProject addPluginRepository(MavenProject project, Repository r) {
        Model originalModel = project.getOriginalModel();
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        repositories.add(r);
        Mockito.when((Object)originalModel.getPluginRepositories()).thenReturn(repositories);
        return project;
    }

    private MavenProject addEmptyPluginRepository(MavenProject project) {
        Model originalModel = project.getOriginalModel();
        ArrayList repositories = new ArrayList();
        Mockito.when((Object)originalModel.getPluginRepositories()).thenReturn(repositories);
        return project;
    }

    @Test
    public void testAllBannedNoRepositories() throws EnforcerRuleException {
        MavenProject baseProject = this.createStandAloneProject();
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testAllBannedWithRepository() throws EnforcerRuleException {
        MavenProject baseProject = this.createStandAloneProject();
        this.addRepository(baseProject, this.createRepository("repo", "http://example.com/repo"));
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testAllBannedWithPluginRepository() throws EnforcerRuleException {
        MavenProject baseProject = this.createStandAloneProject();
        this.addPluginRepository(baseProject, this.createRepository("repo", "http://example.com/repo"));
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test
    public void testAllBannedWithAllowedRepositories() throws EnforcerRuleException {
        String repositoryId = "repo";
        this.rule.setAllowedRepositories(Collections.singletonList("repo"));
        MavenProject baseProject = this.createStandAloneProject();
        this.addRepository(baseProject, this.createRepository("repo", "http://example.com/repo"));
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test
    public void testRepositoriesNotBannedWithSingleRepository() throws EnforcerRuleException {
        String repositoryId = "repo";
        this.rule.setBanRepositories(false);
        MavenProject baseProject = this.createStandAloneProject();
        this.addRepository(baseProject, this.createRepository("repo", "http://example.com/repo"));
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test
    public void testRepositoriesNotBannedWithOutAnyRepository() throws EnforcerRuleException {
        this.rule.setBanRepositories(false);
        MavenProject baseProject = this.createStandAloneProject();
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test
    public void testAllBannedWithAllowedPluginRepositories() throws EnforcerRuleException {
        String repositoryId = "repo";
        this.rule.setAllowedPluginRepositories(Collections.singletonList("repo"));
        MavenProject baseProject = this.createStandAloneProject();
        this.addPluginRepository(baseProject, this.createRepository("repo", "http://example.com/repo"));
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test
    public void testPluginRepositoriesNotBannedWithSinglePluginRepository() throws EnforcerRuleException {
        String repositoryId = "repo";
        this.rule.setBanPluginRepositories(false);
        MavenProject baseProject = this.createStandAloneProject();
        this.addPluginRepository(baseProject, this.createRepository("repo", "http://example.com/repo"));
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test
    public void testPluginRepositoriesNotBannedWithOutAnyRepository() throws EnforcerRuleException {
        this.rule.setBanPluginRepositories(false);
        MavenProject baseProject = this.createStandAloneProject();
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testAllBannedWithSnapshotRepository() throws EnforcerRuleException {
        MavenProject baseProject = this.createStandAloneProject();
        this.addRepository(baseProject, this.createSnapshotRepository("repo", "http://example.com/repo"));
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test
    public void testAllBannedWithSnapshotRepositoryAllowedRepositories() throws EnforcerRuleException {
        String repositoryId = "repo";
        this.rule.setAllowedRepositories(Collections.singletonList("repo"));
        MavenProject baseProject = this.createStandAloneProject();
        this.addRepository(baseProject, this.createSnapshotRepository("repo", "http://example.com/repo"));
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test
    public void testAllBannedWithSnapshotRepositoryAndSetAllowSnapshotRepositories() throws EnforcerRuleException {
        String repositoryId = "repo";
        this.rule.setAllowSnapshotRepositories(true);
        MavenProject baseProject = this.createStandAloneProject();
        this.addRepository(baseProject, this.createSnapshotRepository("repo", "http://example.com/repo"));
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test
    public void testAllBannedWithSnapshotPluginRepositoryAndSetAllowSnapshotPluginRepositories() throws EnforcerRuleException {
        String repositoryId = "repo";
        this.rule.setAllowSnapshotPluginRepositories(true);
        MavenProject baseProject = this.createStandAloneProject();
        this.addPluginRepository(baseProject, this.createSnapshotRepository("repo", "http://example.com/repo"));
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test
    public void testAllBannedWithEmptyRepository() throws EnforcerRuleException {
        MavenProject baseProject = this.createStandAloneProject();
        this.addEmptyRepository(baseProject);
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }

    @Test
    public void testAllBannedWithEmptyPluginRepository() throws EnforcerRuleException {
        MavenProject baseProject = this.createStandAloneProject();
        this.addEmptyPluginRepository(baseProject);
        this.setupSortedProjects(Collections.singletonList(baseProject));
        this.rule.execute(this.helper);
    }
}

