/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Iterator;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.RequireOS;
import org.codehaus.plexus.util.Os;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestRequireOS {
    @Test
    public void testOS() {
        SystemStreamLog log = new SystemStreamLog();
        RequireOS rule = new RequireOS((ProfileActivator)new OperatingSystemProfileActivator());
        rule.displayOSInfo((Log)log, true);
        Iterator iter = Os.getValidFamilies().iterator();
        String validFamily = null;
        String invalidFamily = null;
        while (iter.hasNext()) {
            String fam = (String)iter.next();
            if (Os.isFamily((String)fam)) continue;
            invalidFamily = fam;
            break;
        }
        validFamily = Os.OS_FAMILY;
        log.info((CharSequence)("Testing Mojo Using Valid Family: " + validFamily + " Invalid Family: " + invalidFamily));
        rule.setFamily(validFamily);
        Assert.assertTrue((boolean)rule.isAllowed());
        rule.setFamily(invalidFamily);
        Assert.assertFalse((boolean)rule.isAllowed());
        rule.setFamily("!" + invalidFamily);
        Assert.assertTrue((boolean)rule.isAllowed());
        rule.setFamily(null);
        rule.setArch(Os.OS_ARCH);
        Assert.assertTrue((boolean)rule.isAllowed());
        rule.setArch("somecrazyarch");
        Assert.assertFalse((boolean)rule.isAllowed());
        rule.setArch("!somecrazyarch");
        Assert.assertTrue((boolean)rule.isAllowed());
        rule.setArch(null);
        rule.setName(Os.OS_NAME);
        Assert.assertTrue((boolean)rule.isAllowed());
        rule.setName("somecrazyname");
        Assert.assertFalse((boolean)rule.isAllowed());
        rule.setName("!somecrazyname");
        Assert.assertTrue((boolean)rule.isAllowed());
        rule.setName(null);
        rule.setVersion(Os.OS_VERSION);
        Assert.assertTrue((boolean)rule.isAllowed());
        rule.setVersion("somecrazyversion");
        Assert.assertFalse((boolean)rule.isAllowed());
        rule.setVersion("!somecrazyversion");
        Assert.assertTrue((boolean)rule.isAllowed());
    }

    @Test
    public void testInvalidFamily() throws Exception {
        RequireOS rule = new RequireOS();
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper();
        helper.getContainer().addComponent((Object)new OperatingSystemProfileActivator(), "os");
        rule.setFamily("junk");
        try {
            rule.execute(helper);
            Assert.fail((String)"Expected MojoExecution Exception because of invalid family type");
        }
        catch (EnforcerRuleException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Invalid Family type used. Valid family types are: "));
        }
    }

    @Test
    public void testId() {
        RequireOS rule = new RequireOS();
        rule.getCacheId();
    }
}

