/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.testing.ArtifactStubFactory;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.plugins.enforcer.RequireReleaseVersion;
import org.apache.maven.plugins.enforcer.utils.EnforcerRuleUtilsHelper;

public class TestRequireReleaseVersion
extends TestCase {
    public void testMojo() throws IOException {
        ArtifactStubFactory factory = new ArtifactStubFactory();
        MockProject project = new MockProject();
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(project);
        project.setArtifact(factory.getReleaseArtifact());
        RequireReleaseVersion rule = new RequireReleaseVersion();
        EnforcerRuleUtilsHelper.execute((EnforcerRule)rule, helper, false);
        project.setArtifact(factory.getSnapshotArtifact());
        EnforcerRuleUtilsHelper.execute((EnforcerRule)rule, helper, true);
        project.setArtifact(factory.getReleaseArtifact());
        MockProject parent = new MockProject();
        parent.setArtifact(factory.getSnapshotArtifact());
        project.setParent(parent);
        helper = EnforcerTestUtils.getHelper(project);
        rule.setFailWhenParentIsSnapshot(true);
        EnforcerRuleUtilsHelper.execute((EnforcerRule)rule, helper, true);
        rule.setFailWhenParentIsSnapshot(false);
        EnforcerRuleUtilsHelper.execute((EnforcerRule)rule, helper, false);
    }

    public void testCache() {
        RequireReleaseVersion rule = new RequireReleaseVersion();
        TestRequireReleaseVersion.assertFalse((boolean)rule.isCacheable());
        TestRequireReleaseVersion.assertFalse((boolean)rule.isResultValid(null));
        TestRequireReleaseVersion.assertEquals((String)"0", (String)rule.getCacheId());
    }
}

