/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.IOException;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.testing.ArtifactStubFactory;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.plugins.enforcer.RequireSnapshotVersion;
import org.apache.maven.plugins.enforcer.utils.EnforcerRuleUtilsHelper;
import org.apache.maven.project.MavenProject;
import org.junit.Before;
import org.junit.Test;

public class TestRequireSnapshotVersion {
    private MavenProject project;
    private EnforcerRuleHelper helper;
    private ArtifactStubFactory factory;
    private RequireSnapshotVersion rule;

    @Before
    public void before() {
        this.project = new MockProject();
        this.helper = EnforcerTestUtils.getHelper(this.project);
        this.factory = new ArtifactStubFactory();
        this.rule = new RequireSnapshotVersion();
    }

    @Test
    public void testRequireSnapshot() throws IOException {
        this.project.setArtifact(this.factory.getReleaseArtifact());
        EnforcerRuleUtilsHelper.execute((EnforcerRule)this.rule, this.helper, true);
        this.project.setArtifact(this.factory.getSnapshotArtifact());
        EnforcerRuleUtilsHelper.execute((EnforcerRule)this.rule, this.helper, false);
    }

    @Test
    public void testWithParentShouldFail() throws IOException {
        this.project.setArtifact(this.factory.getSnapshotArtifact());
        this.rule.setFailWhenParentIsRelease(true);
        MockProject parent = new MockProject();
        parent.setArtifact(this.factory.getReleaseArtifact());
        this.project.setParent((MavenProject)parent);
        EnforcerRuleUtilsHelper.execute((EnforcerRule)this.rule, this.helper, true);
        parent = new MockProject();
        parent.setArtifact(this.factory.getSnapshotArtifact());
        this.project.setParent((MavenProject)parent);
        EnforcerRuleUtilsHelper.execute((EnforcerRule)this.rule, this.helper, false);
    }

    @Test
    public void testWithParentShouldPass() throws IOException {
        this.project.setArtifact(this.factory.getSnapshotArtifact());
        this.rule.setFailWhenParentIsRelease(false);
        MockProject parent = new MockProject();
        parent.setArtifact(this.factory.getReleaseArtifact());
        this.project.setParent((MavenProject)parent);
        EnforcerRuleUtilsHelper.execute((EnforcerRule)this.rule, this.helper, false);
        parent = new MockProject();
        parent.setArtifact(this.factory.getSnapshotArtifact());
        this.project.setParent((MavenProject)parent);
        EnforcerRuleUtilsHelper.execute((EnforcerRule)this.rule, this.helper, false);
    }
}

