/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import org.fxmisc.richtext.StyleSpan;
import org.fxmisc.richtext.StyleSpans;
import org.fxmisc.richtext.StyleSpansBase;

class AppendedSpans<S>
extends StyleSpansBase<S> {
    private final StyleSpans<S> original;
    private final StyleSpan<S> appended;
    private int length = -1;
    private int spanCount = -1;

    public AppendedSpans(StyleSpans<S> original, StyleSpan<S> appended) {
        this.original = original;
        this.appended = appended;
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.length = this.original.length() + this.appended.getLength();
        }
        return this.length;
    }

    @Override
    public int getSpanCount() {
        if (this.spanCount == -1) {
            this.spanCount = this.original.getSpanCount() + 1;
        }
        return this.spanCount;
    }

    @Override
    public StyleSpan<S> getStyleSpan(int index) {
        if (index == this.getSpanCount() - 1) {
            return this.appended;
        }
        return this.original.getStyleSpan(index);
    }
}

