/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.Map;
import javafx.scene.control.IndexRange;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.fxmisc.richtext.EditActions;

public interface ClipboardActions<S>
extends EditActions<S> {
    default public void cut() {
        this.copy();
        IndexRange selection = this.getSelection();
        this.deleteText(selection.getStart(), selection.getEnd());
    }

    default public void copy() {
        String selectedText = this.getSelectedText();
        if (selectedText.length() > 0) {
            ClipboardContent content = new ClipboardContent();
            content.putString(selectedText);
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    default public void paste() {
        String text;
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.hasString() && (text = clipboard.getString()) != null) {
            this.replaceSelection(text);
        }
    }
}

