/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.fxmisc.richtext.LineTerminator;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.PlainTextChange;
import org.fxmisc.richtext.ReadOnlyStyledDocument;
import org.fxmisc.richtext.RichTextChange;
import org.fxmisc.richtext.StyleSpans;
import org.fxmisc.richtext.StyledDocument;
import org.fxmisc.richtext.StyledDocumentBase;
import org.fxmisc.richtext.TwoDimensional;
import org.reactfx.EventSource;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Guard;
import org.reactfx.inhibeans.property.ReadOnlyIntegerWrapper;

final class EditableStyledDocument<S>
extends StyledDocumentBase<S, ObservableList<Paragraph<S>>> {
    private final StringBinding text = Bindings.createStringBinding(() -> this.getText(0, this.length()), (Observable[])new Observable[0]);
    private final ReadOnlyIntegerWrapper length = new ReadOnlyIntegerWrapper();
    private final EventSource<Integer> textChangePosition = new EventSource();
    private final EventSource<Integer> styleChangePosition = new EventSource();
    private final EventSource<Integer> textRemovalEnd = new EventSource();
    private final EventSource<Integer> styleChangeEnd = new EventSource();
    private final EventSource<String> insertedText = new EventSource();
    private final EventSource<StyledDocument<S>> insertedDocument = new EventSource();
    private final EventSource<Integer> insertionLength = new EventSource();
    private final EventSource<Void> styleChangeDone = new EventSource();
    private final EventStream<PlainTextChange> plainTextChanges;
    private final EventStream<RichTextChange<S>> richChanges;
    final BooleanProperty useInitialStyleForInsertion;
    private final S initialStyle;

    @Override
    public String getText() {
        return this.text.getValue();
    }

    public ObservableValue<String> textProperty() {
        return this.text;
    }

    public int getLength() {
        return this.length.get();
    }

    public ObservableIntegerValue lengthProperty() {
        return this.length.getReadOnlyProperty();
    }

    @Override
    public int length() {
        return this.length.get();
    }

    @Override
    public ObservableList<Paragraph<S>> getParagraphs() {
        return FXCollections.unmodifiableObservableList((ObservableList)((ObservableList)this.paragraphs));
    }

    public ReadOnlyStyledDocument<S> snapshot() {
        return new ReadOnlyStyledDocument(this.paragraphs, ReadOnlyStyledDocument.ParagraphsPolicy.COPY);
    }

    public EventStream<PlainTextChange> plainTextChanges() {
        return this.plainTextChanges;
    }

    public EventStream<RichTextChange<S>> richChanges() {
        return this.richChanges;
    }

    EditableStyledDocument(S initialStyle) {
        super(FXCollections.observableArrayList((Object[])new Paragraph[]{new Paragraph<S>("", initialStyle)}));
        EventStream removedText = EventStreams.zip(this.textChangePosition, this.textRemovalEnd).map((a, b) -> this.getText((int)a, (int)b));
        EventStream changePosition = EventStreams.merge((EventStream[])new EventStream[]{this.textChangePosition, this.styleChangePosition});
        EventStream removalEnd = EventStreams.merge((EventStream[])new EventStream[]{this.textRemovalEnd, this.styleChangeEnd});
        EventStream removedDocument = EventStreams.zip((EventStream)changePosition, (EventStream)removalEnd).map((a, b) -> this.subSequence((int)a, (int)b));
        EventStream insertionEnd = EventStreams.merge((EventStream[])new EventStream[]{changePosition.emitBothOnEach(this.insertionLength).map((start, len) -> start + len), this.styleChangeEnd.emitOn(this.styleChangeDone)});
        EventStream insertedDocument = EventStreams.merge((EventStream[])new EventStream[]{this.insertedDocument, changePosition.emitBothOnEach(insertionEnd).map((a, b) -> this.subSequence((int)a, (int)b))});
        this.plainTextChanges = EventStreams.zip(this.textChangePosition, (EventStream)removedText, this.insertedText).map((pos, removed, inserted) -> new PlainTextChange((int)pos, (String)removed, (String)inserted));
        this.richChanges = EventStreams.zip((EventStream)changePosition, (EventStream)removedDocument, (EventStream)insertedDocument).map((pos, removed, inserted) -> new RichTextChange((int)pos, removed, inserted));
        this.useInitialStyleForInsertion = new SimpleBooleanProperty();
        this.initialStyle = initialStyle;
        this.length.set(0);
    }

    public void replaceText(int start, int end, String replacement) {
        this.ensureValidRange(start, end);
        this.replace(start, end, replacement, (repl, pos) -> EditableStyledDocument.stringToParagraphs(repl, this.getStyleForInsertionAt((TwoDimensional.Position)pos)), repl -> {
            this.insertedText.push(repl);
            this.insertionLength.push((Object)repl.length());
        });
    }

    public void replace(int start, int end, StyledDocument<S> replacement) {
        this.ensureValidRange(start, end);
        this.replace(start, end, replacement, (repl, pos) -> repl.getParagraphs(), repl -> {
            this.insertedText.push((Object)repl.toString());
            StyledDocument doc = repl instanceof ReadOnlyStyledDocument ? repl : new ReadOnlyStyledDocument(repl.getParagraphs(), ReadOnlyStyledDocument.ParagraphsPolicy.COPY);
            this.insertedDocument.push((Object)doc);
        });
    }

    public void setStyle(int from, int to, S style) {
        this.ensureValidRange(from, to);
        try (Guard commitOnClose = this.beginStyleChange(from, to);){
            TwoDimensional.Position start = this.navigator.offsetToPosition(from, TwoDimensional.Bias.Forward);
            TwoDimensional.Position end = to == from ? start : start.offsetBy(to - from, TwoDimensional.Bias.Backward);
            int firstParIdx = start.getMajor();
            int firstParFrom = start.getMinor();
            int lastParIdx = end.getMajor();
            int lastParTo = end.getMinor();
            if (firstParIdx == lastParIdx) {
                Paragraph<S> p = (Paragraph<S>)((ObservableList)this.paragraphs).get(firstParIdx);
                p = p.restyle(firstParFrom, lastParTo, style);
                ((ObservableList)this.paragraphs).set(firstParIdx, p);
            } else {
                int affectedPars = lastParIdx - firstParIdx + 1;
                ArrayList<Paragraph<S>> restyledPars = new ArrayList<Paragraph<S>>(affectedPars);
                Paragraph firstPar = (Paragraph)((ObservableList)this.paragraphs).get(firstParIdx);
                restyledPars.add(firstPar.restyle(firstParFrom, firstPar.length(), style));
                for (int i = firstParIdx + 1; i < lastParIdx; ++i) {
                    Paragraph p = (Paragraph)((ObservableList)this.paragraphs).get(i);
                    restyledPars.add(p.restyle(style));
                }
                Paragraph lastPar = (Paragraph)((ObservableList)this.paragraphs).get(lastParIdx);
                restyledPars.add(lastPar.restyle(0, lastParTo, style));
                this.setAll(firstParIdx, lastParIdx + 1, restyledPars);
            }
        }
    }

    public void setStyle(int paragraph, S style) {
        Paragraph<S> p = (Paragraph<S>)((ObservableList)this.paragraphs).get(paragraph);
        int start = this.position(paragraph, 0).toOffset();
        int end = start + p.length();
        try (Guard commitOnClose = this.beginStyleChange(start, end);){
            p = p.restyle(style);
            ((ObservableList)this.paragraphs).set(paragraph, p);
        }
    }

    public void setStyle(int paragraph, int fromCol, int toCol, S style) {
        this.ensureValidParagraphRange(paragraph, fromCol, toCol);
        int parOffset = this.position(paragraph, 0).toOffset();
        int start = parOffset + fromCol;
        int end = parOffset + toCol;
        try (Guard commitOnClose = this.beginStyleChange(start, end);){
            Paragraph<S> p = (Paragraph<S>)((ObservableList)this.paragraphs).get(paragraph);
            p = p.restyle(fromCol, toCol, style);
            ((ObservableList)this.paragraphs).set(paragraph, p);
        }
    }

    public void setStyleSpans(int from, StyleSpans<? extends S> styleSpans) {
        int len = styleSpans.length();
        this.ensureValidRange(from, from + len);
        TwoDimensional.Position start = this.offsetToPosition(from, TwoDimensional.Bias.Forward);
        TwoDimensional.Position end = start.offsetBy(len, TwoDimensional.Bias.Backward);
        int skip = this.terminatorLengthToSkip(start);
        int trim = this.terminatorLengthToTrim(end);
        if (skip + trim >= len) {
            return;
        }
        if (skip + trim > 0) {
            styleSpans = styleSpans.subView(skip, len - trim);
            len -= skip + trim;
            from += skip;
            start = start.offsetBy(skip, TwoDimensional.Bias.Forward);
            end = end.offsetBy(-trim, TwoDimensional.Bias.Backward);
        }
        try (Guard commitOnClose = this.beginStyleChange(from, from + len);){
            int firstParIdx = start.getMajor();
            int firstParFrom = start.getMinor();
            int lastParIdx = end.getMajor();
            int lastParTo = end.getMinor();
            if (firstParIdx == lastParIdx) {
                Paragraph p = (Paragraph)((ObservableList)this.paragraphs).get(firstParIdx);
                Paragraph<? extends S> q = p.restyle(firstParFrom, styleSpans);
                if (q != p) {
                    ((ObservableList)this.paragraphs).set(firstParIdx, q);
                }
            } else {
                TwoDimensional.Position spansTo;
                TwoDimensional.Position spansFrom;
                Paragraph firstPar = (Paragraph)((ObservableList)this.paragraphs).get(firstParIdx);
                Paragraph<? extends S> q = firstPar.restyle(firstParFrom, styleSpans.subView(spansFrom = styleSpans.position(0, 0), spansTo = spansFrom.offsetBy(firstPar.length() - firstParFrom, TwoDimensional.Bias.Backward)));
                if (q != firstPar) {
                    ((ObservableList)this.paragraphs).set(firstParIdx, q);
                }
                spansFrom = spansTo.offsetBy(firstPar.getLineTerminator().map(LineTerminator::length).orElse(0), TwoDimensional.Bias.Forward);
                for (int i = firstParIdx + 1; i < lastParIdx; ++i) {
                    Paragraph par = (Paragraph)((ObservableList)this.paragraphs).get(i);
                    q = par.restyle(0, styleSpans.subView(spansFrom, spansTo = spansFrom.offsetBy(par.length(), TwoDimensional.Bias.Backward)));
                    if (q != par) {
                        ((ObservableList)this.paragraphs).set(i, q);
                    }
                    spansFrom = spansTo.offsetBy(par.getLineTerminator().map(LineTerminator::length).orElse(0), TwoDimensional.Bias.Forward);
                }
                Paragraph lastPar = (Paragraph)((ObservableList)this.paragraphs).get(lastParIdx);
                q = lastPar.restyle(0, styleSpans.subView(spansFrom, spansTo = spansFrom.offsetBy(lastParTo, TwoDimensional.Bias.Backward)));
                if (q != lastPar) {
                    ((ObservableList)this.paragraphs).set(lastParIdx, q);
                }
            }
        }
    }

    public void setStyleSpans(int paragraph, int from, StyleSpans<? extends S> styleSpans) {
        int len = styleSpans.length();
        this.ensureValidParagraphRange(paragraph, from, len);
        int parOffset = this.position(paragraph, 0).toOffset();
        int start = parOffset + from;
        int end = start + len;
        try (Guard commitOnClose = this.beginStyleChange(start, end);){
            Paragraph p = (Paragraph)((ObservableList)this.paragraphs).get(paragraph);
            Paragraph<? extends S> q = p.restyle(from, styleSpans);
            if (q != p) {
                ((ObservableList)this.paragraphs).set(paragraph, q);
            }
        }
    }

    private static <S> List<Paragraph<S>> stringToParagraphs(String str, S style) {
        Matcher m = LineTerminator.regex().matcher(str);
        int n = 1;
        while (m.find()) {
            ++n;
        }
        ArrayList<Paragraph<S>> res = new ArrayList<Paragraph<S>>(n);
        int start = 0;
        m.reset();
        while (m.find()) {
            String s = str.substring(start, m.start());
            LineTerminator t = LineTerminator.from(m.group());
            res.add(new Paragraph<S>(s, style).terminate(t));
            start = m.end();
        }
        String last = str.substring(start);
        res.add(new Paragraph<S>(last, style));
        return res;
    }

    private void ensureValidRange(int start, int end) {
        this.ensureValidRange(start, end, this.length());
    }

    private void ensureValidParagraphRange(int par, int start, int end) {
        if (par < 0 || par >= ((ObservableList)this.paragraphs).size()) {
            throw new IllegalArgumentException(par + " is not a valid paragraph index. Must be from [0, " + ((ObservableList)this.paragraphs).size() + ")");
        }
        this.ensureValidRange(start, end, ((Paragraph)((ObservableList)this.paragraphs).get(par)).fullLength());
    }

    private void ensureValidRange(int start, int end, int len) {
        if (start < 0) {
            throw new IllegalArgumentException("start cannot be negative: " + start);
        }
        if (end > len) {
            throw new IllegalArgumentException("end is greater than length: " + end + " > " + len);
        }
        if (start > end) {
            throw new IllegalArgumentException("start is greater than end: " + start + " > " + end);
        }
    }

    private int terminatorLengthToSkip(TwoDimensional.Position pos) {
        Paragraph par = (Paragraph)((ObservableList)this.paragraphs).get(pos.getMajor());
        int skipSum = 0;
        while (pos.getMinor() >= par.length() && pos.getMinor() < par.fullLength()) {
            int skipLen = par.fullLength() - pos.getMinor();
            skipSum += skipLen;
            pos = pos.offsetBy(skipLen, TwoDimensional.Bias.Forward);
            par = (Paragraph)((ObservableList)this.paragraphs).get(pos.getMajor());
        }
        return skipSum;
    }

    private int terminatorLengthToTrim(TwoDimensional.Position pos) {
        int parLen = ((Paragraph)((ObservableList)this.paragraphs).get(pos.getMajor())).length();
        int trimSum = 0;
        while (pos.getMinor() > parLen) {
            int trimLen = pos.getMinor() - parLen;
            trimSum += trimLen;
            pos = pos.offsetBy(-trimLen, TwoDimensional.Bias.Backward);
            parLen = ((Paragraph)((ObservableList)this.paragraphs).get(pos.getMajor())).length();
        }
        return trimSum;
    }

    private Guard beginStyleChange(int start, int end) {
        this.styleChangePosition.push((Object)start);
        this.styleChangeEnd.push((Object)end);
        return () -> this.styleChangeDone.push(null);
    }

    private <D extends CharSequence> void replace(int start, int end, D replacement, BiFunction<D, TwoDimensional.Position, List<Paragraph<S>>> replacementToParagraphs, Consumer<D> publishReplacement) {
        this.textChangePosition.push((Object)start);
        this.textRemovalEnd.push((Object)end);
        TwoDimensional.Position start2D = this.navigator.offsetToPosition(start, TwoDimensional.Bias.Forward);
        TwoDimensional.Position end2D = start2D.offsetBy(end - start, TwoDimensional.Bias.Forward);
        int firstParIdx = start2D.getMajor();
        int firstParFrom = start2D.getMinor();
        int lastParIdx = end2D.getMajor();
        int lastParTo = end2D.getMinor();
        Paragraph firstPar = ((Paragraph)((ObservableList)this.paragraphs).get(firstParIdx)).trim(firstParFrom);
        Paragraph lastPar = ((Paragraph)((ObservableList)this.paragraphs).get(lastParIdx)).subSequence(lastParTo);
        List<Paragraph<S>> replacementPars = replacementToParagraphs.apply(replacement, start2D);
        List newPars = this.join(firstPar, replacementPars, lastPar);
        this.setAll(firstParIdx, lastParIdx + 1, newPars);
        int newLength = this.length.get() - (end - start) + replacement.length();
        this.length.blockWhile(() -> {
            this.length.set(newLength);
            this.text.invalidate();
        });
        publishReplacement.accept(replacement);
    }

    private List<Paragraph<S>> join(Paragraph<S> first, List<Paragraph<S>> middle, Paragraph<S> last) {
        int m = middle.size();
        if (m == 0) {
            return this.join(first, last);
        }
        if (!first.isTerminated()) {
            first = first.concat(middle.get(0));
            middle = middle.subList(1, m);
            return this.join(first, middle, last);
        }
        Paragraph<S> lastMiddle = middle.get(m - 1);
        if (lastMiddle.isTerminated()) {
            int n = 1 + m + 1;
            ArrayList<Paragraph<S>> res = new ArrayList<Paragraph<S>>(n);
            res.add(first);
            res.addAll(middle);
            res.add(last);
            return res;
        }
        int n = 1 + m;
        ArrayList<Paragraph<S>> res = new ArrayList<Paragraph<S>>(n);
        res.add(first);
        res.addAll(middle.subList(0, m - 1));
        res.add(lastMiddle.concat(last));
        return res;
    }

    private List<Paragraph<S>> join(Paragraph<S> first, Paragraph<S> last) {
        return first.isTerminated() ? Arrays.asList(first, last) : Arrays.asList(first.concat(last));
    }

    private void setAll(int startIdx, int endIdx, Collection<Paragraph<S>> pars) {
        if (startIdx > 0 || endIdx < ((ObservableList)this.paragraphs).size()) {
            ((ObservableList)this.paragraphs).subList(startIdx, endIdx).clear();
            ((ObservableList)this.paragraphs).addAll(startIdx, pars);
        } else {
            ((ObservableList)this.paragraphs).setAll(pars);
        }
    }

    private S getStyleForInsertionAt(TwoDimensional.Position insertionPos) {
        if (this.useInitialStyleForInsertion.get()) {
            return this.initialStyle;
        }
        Paragraph par = (Paragraph)((ObservableList)this.paragraphs).get(insertionPos.getMajor());
        return par.getStyleAtPosition(insertionPos.getMinor());
    }
}

