/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.function.IntFunction;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.fxmisc.richtext.StyledTextArea;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;

public class LineNumberFactory
implements IntFunction<Node> {
    private static final String STYLESHEET = LineNumberFactory.class.getResource("lineno.css").toExternalForm();
    private final EventStream<Integer> nParagraphs;

    public static IntFunction<Node> get(StyledTextArea<?> area) {
        return new LineNumberFactory(area);
    }

    private LineNumberFactory(StyledTextArea<?> area) {
        this.nParagraphs = EventStreams.sizeOf(area.getParagraphs());
    }

    @Override
    public Node apply(int idx) {
        Label lineNo = new Label();
        lineNo.getStyleClass().add((Object)"lineno");
        lineNo.getStylesheets().add((Object)STYLESHEET);
        EventStreams.valuesOf((ObservableValue)lineNo.sceneProperty()).flatMap(scene -> scene != null ? this.nParagraphs.map(n2 -> this.format(idx + 1, (int)n2)) : EventStreams.never()).feedTo((WritableValue)lineNo.textProperty());
        return lineNo;
    }

    private String format(int x, int max) {
        int digits = (int)Math.floor(Math.log10(max)) + 1;
        return String.format("%0" + digits + "d", x);
    }
}

