/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.regex.Pattern;

public enum LineTerminator {
    CR("\r"),
    LF("\n"),
    CRLF("\r\n");

    private static final Pattern regex;
    private final String s;

    public static LineTerminator from(String s) {
        for (LineTerminator t : LineTerminator.values()) {
            if (!t.asString().equals(s)) continue;
            return t;
        }
        throw new IllegalArgumentException("Not a line terminator: " + s);
    }

    public static boolean isLineTerminatorChar(char c) {
        return c == '\r' || c == '\n';
    }

    public static Pattern regex() {
        return regex;
    }

    private LineTerminator(String s) {
        this.s = s;
    }

    public String asString() {
        return this.s;
    }

    public int length() {
        return this.s.length();
    }

    public LineTerminator trim(int length) {
        return LineTerminator.from(this.s.substring(0, length));
    }

    public LineTerminator subSequence(int start) {
        return LineTerminator.from(this.s.substring(start));
    }

    static {
        regex = Pattern.compile("\r\n|\r|\n");
    }
}

