/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.TextEditingArea;

public interface NavigationActions<S>
extends TextEditingArea<S> {
    default public void moveTo(int pos) {
        this.selectRange(pos, pos);
    }

    default public void moveTo(int pos, SelectionPolicy selectionPolicy) {
        switch (selectionPolicy) {
            case CLEAR: {
                this.selectRange(pos, pos);
                break;
            }
            case ADJUST: {
                this.selectRange(this.getAnchor(), pos);
                break;
            }
            case EXTEND: {
                IndexRange sel = this.getSelection();
                int anchor = pos <= sel.getStart() ? sel.getEnd() : (pos >= sel.getEnd() ? sel.getStart() : this.getAnchor());
                this.selectRange(anchor, pos);
            }
        }
    }

    default public void previousChar(SelectionPolicy selectionPolicy) {
        if (this.getCaretPosition() > 0) {
            int newCaretPos = Character.offsetByCodePoints(this.getText(), this.getCaretPosition(), -1);
            this.moveTo(newCaretPos, selectionPolicy);
        }
    }

    default public void nextChar(SelectionPolicy selectionPolicy) {
        if (this.getCaretPosition() < this.getLength()) {
            int newCaretPos = Character.offsetByCodePoints(this.getText(), this.getCaretPosition(), 1);
            this.moveTo(newCaretPos, selectionPolicy);
        }
    }

    default public void previousWord(SelectionPolicy selectionPolicy) {
        if (this.getLength() == 0) {
            return;
        }
        BreakIterator wordBreakIterator = BreakIterator.getWordInstance();
        wordBreakIterator.setText(this.getText());
        wordBreakIterator.preceding(this.getCaretPosition());
        wordBreakIterator.previous();
        this.moveTo(wordBreakIterator.current(), selectionPolicy);
    }

    default public void nextWord(SelectionPolicy selectionPolicy) {
        if (this.getLength() == 0) {
            return;
        }
        BreakIterator wordBreakIterator = BreakIterator.getWordInstance();
        wordBreakIterator.setText(this.getText());
        wordBreakIterator.following(this.getCaretPosition());
        wordBreakIterator.next();
        this.moveTo(wordBreakIterator.current(), selectionPolicy);
    }

    default public void lineStart(SelectionPolicy selectionPolicy) {
        this.moveTo(this.getCaretPosition() - this.getCaretColumn(), selectionPolicy);
    }

    default public void lineEnd(SelectionPolicy selectionPolicy) {
        int lineLen = this.getText(this.getCurrentParagraph()).length();
        int newPos = this.getCaretPosition() - this.getCaretColumn() + lineLen;
        this.moveTo(newPos, selectionPolicy);
    }

    default public void start(SelectionPolicy selectionPolicy) {
        this.moveTo(0, selectionPolicy);
    }

    default public void end(SelectionPolicy selectionPolicy) {
        this.moveTo(this.getLength(), selectionPolicy);
    }

    default public void selectLine() {
        this.lineStart(SelectionPolicy.CLEAR);
        this.lineEnd(SelectionPolicy.ADJUST);
    }

    default public void selectAll() {
        this.selectRange(0, this.getLength());
    }

    default public void deselect() {
        int p = this.getCaretPosition();
        this.selectRange(p, p);
    }

    public static enum SelectionPolicy {
        CLEAR,
        ADJUST,
        EXTEND;

    }
}

