/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.StyledDocumentBase;

public class ReadOnlyStyledDocument<S>
extends StyledDocumentBase<S, List<Paragraph<S>>> {
    private int length = -1;
    private String text = null;

    ReadOnlyStyledDocument(List<Paragraph<S>> paragraphs, ParagraphsPolicy policy) {
        super(policy == ParagraphsPolicy.ADOPT ? paragraphs : new ArrayList(paragraphs));
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.length = this.computeLength();
        }
        return this.length;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = this.getText(0, this.length());
        }
        return this.text;
    }

    @Override
    public List<Paragraph<S>> getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    private int computeLength() {
        return this.paragraphs.stream().mapToInt(p -> p.fullLength()).sum();
    }

    static enum ParagraphsPolicy {
        ADOPT,
        COPY;

    }
}

