/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.fxmisc.richtext.StyleSpan;
import org.fxmisc.richtext.StyleSpans;
import org.fxmisc.richtext.StyleSpansBase;

public class StyleSpansBuilder<S> {
    private boolean created = false;
    private final ArrayList<StyleSpan<S>> spans;

    public StyleSpansBuilder(int initialCapacity) {
        this.spans = new ArrayList(initialCapacity);
    }

    public StyleSpansBuilder() {
        this.spans = new ArrayList();
    }

    public StyleSpansBuilder<S> add(StyleSpan<S> styleSpan) {
        this.ensureNotCreated();
        this._add(styleSpan);
        return this;
    }

    public StyleSpansBuilder<S> add(S style, int length) {
        return this.add(new StyleSpan<S>(style, length));
    }

    public StyleSpansBuilder<S> addAll(Collection<? extends StyleSpan<S>> styleSpans) {
        return this.addAll(styleSpans, styleSpans.size());
    }

    public StyleSpansBuilder<S> addAll(Iterable<? extends StyleSpan<S>> styleSpans, int sizeHint) {
        this.spans.ensureCapacity(this.spans.size() + sizeHint);
        return this.addAll(styleSpans);
    }

    public StyleSpansBuilder<S> addAll(Iterable<? extends StyleSpan<S>> styleSpans) {
        this.ensureNotCreated();
        for (StyleSpan<S> span : styleSpans) {
            this._add(span);
        }
        return this;
    }

    public StyleSpans<S> create() {
        this.ensureNotCreated();
        if (this.spans.isEmpty()) {
            throw new IllegalStateException("No spans have been added");
        }
        this.created = true;
        return new StyleSpansImpl<S>(Collections.unmodifiableList(this.spans));
    }

    private void _add(StyleSpan<S> span) {
        if (this.spans.isEmpty()) {
            this.spans.add(span);
        } else if (span.getLength() > 0) {
            if (this.spans.size() == 1 && this.spans.get(0).getLength() == 0) {
                this.spans.set(0, span);
            } else {
                this.spans.add(span);
            }
        }
    }

    private void ensureNotCreated() {
        if (this.created) {
            throw new IllegalStateException("Cannot reus StyleRangesBuilder after StyleRanges have been created.");
        }
    }

    private static class StyleSpansImpl<S>
    extends StyleSpansBase<S> {
        private final List<StyleSpan<S>> spans;
        private int length = -1;

        StyleSpansImpl(List<StyleSpan<S>> spans) {
            this.spans = spans;
        }

        @Override
        public Iterator<StyleSpan<S>> iterator() {
            return this.spans.iterator();
        }

        @Override
        public int length() {
            if (this.length == -1) {
                this.length = this.spans.stream().mapToInt(span -> span.getLength()).sum();
            }
            return this.length;
        }

        @Override
        public int getSpanCount() {
            return this.spans.size();
        }

        @Override
        public StyleSpan<S> getStyleSpan(int index) {
            return this.spans.get(index);
        }
    }
}

