/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

public class StyledText<S>
implements CharSequence {
    private final String text;
    private S style;

    public StyledText(String text, S style) {
        this.text = text;
        this.style = style;
    }

    @Override
    public int length() {
        return this.text.length();
    }

    @Override
    public char charAt(int index) {
        return this.text.charAt(index);
    }

    @Override
    public String toString() {
        return this.text;
    }

    @Override
    public StyledText<S> subSequence(int start, int end) {
        return new StyledText<S>(this.text.substring(start, end), this.style);
    }

    public StyledText<S> subSequence(int start) {
        return new StyledText<S>(this.text.substring(start), this.style);
    }

    public StyledText<S> concat(CharSequence str) {
        return new StyledText<S>(this.text + str, this.style);
    }

    public StyledText<S> spliced(int from, int to, CharSequence replacement) {
        String left = this.text.substring(0, from);
        String right = this.text.substring(to);
        return new StyledText<S>(left + replacement + right, this.style);
    }

    public S getStyle() {
        return this.style;
    }

    public void setStyle(S style) {
        this.style = style;
    }
}

