/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import com.sun.javafx.Utils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Skin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.PopupWindow;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.fxmisc.richtext.ClipboardActions;
import org.fxmisc.richtext.CssProperties;
import org.fxmisc.richtext.EditActions;
import org.fxmisc.richtext.EditableStyledDocument;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.PlainTextChange;
import org.fxmisc.richtext.PopupAlignment;
import org.fxmisc.richtext.RichTextChange;
import org.fxmisc.richtext.StyleSpans;
import org.fxmisc.richtext.StyledDocument;
import org.fxmisc.richtext.TextEditingArea;
import org.fxmisc.richtext.TwoDimensional;
import org.fxmisc.richtext.UndoActions;
import org.fxmisc.richtext.skin.StyledTextAreaBehavior;
import org.fxmisc.richtext.skin.StyledTextAreaVisual;
import org.fxmisc.richtext.util.skin.Skins;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.UndoManagerFactory;
import org.reactfx.EventStream;
import org.reactfx.Guard;
import org.reactfx.Guardian;
import org.reactfx.Indicator;
import org.reactfx.SuspendableEventStream;
import org.reactfx.inhibeans.binding.Binding;
import org.reactfx.inhibeans.binding.IntegerBinding;
import org.reactfx.inhibeans.binding.ObjectBinding;
import org.reactfx.inhibeans.binding.StringBinding;
import org.reactfx.inhibeans.collection.Collections;
import org.reactfx.inhibeans.collection.ObservableList;
import org.reactfx.inhibeans.property.SimpleIntegerProperty;

public class StyledTextArea<S>
extends Control
implements TextEditingArea<S>,
EditActions<S>,
ClipboardActions<S>,
NavigationActions<S>,
UndoActions<S>,
TwoDimensional {
    public static final IndexRange EMPTY_RANGE = new IndexRange(0, 0);
    private final BooleanProperty editable = new CssProperties.EditableProperty<StyledTextArea>(this);
    private final BooleanProperty wrapText = new SimpleBooleanProperty((Object)this, "wrapText");
    private UndoManager undoManager;
    private final StyleableObjectProperty<Font> font = new CssProperties.FontProperty<StyledTextArea>(this);
    private final ObjectProperty<PopupWindow> popupWindow = new SimpleObjectProperty();
    private final ObjectProperty<Point2D> popupAnchorOffset = new SimpleObjectProperty();
    private final ObjectProperty<UnaryOperator<Point2D>> popupAnchorAdjustment = new SimpleObjectProperty();
    private final ObjectProperty<PopupAlignment> popupAlignment = new SimpleObjectProperty((Object)PopupAlignment.CARET_TOP);
    private final ObjectProperty<Duration> mouseOverTextDelay = new SimpleObjectProperty(null);
    private final ObjectProperty<IntFunction<? extends Node>> paragraphGraphicFactory = new SimpleObjectProperty(null);
    private final Binding<String> text;
    private final IntegerBinding length;
    private final IntegerProperty internalCaretPosition = new javafx.beans.property.SimpleIntegerProperty(0);
    private final IntegerBinding caretPosition = IntegerBinding.wrap((ObservableValue)this.internalCaretPosition);
    private final SimpleIntegerProperty anchor = new SimpleIntegerProperty(0);
    private final ObjectProperty<IndexRange> internalSelection = new SimpleObjectProperty((Object)EMPTY_RANGE);
    private final ObjectBinding<IndexRange> selection = ObjectBinding.wrap(this.internalSelection);
    private final StringBinding selectedText;
    private final IntegerBinding currentParagraph;
    private final IntegerBinding caretColumn;
    private final ObservableList<Paragraph<S>> paragraphs;
    private final Indicator beingUpdated = new Indicator();
    private final SuspendableEventStream<PlainTextChange> plainTextChanges;
    private final SuspendableEventStream<RichTextChange<S>> richTextChanges;
    private TwoDimensional.Position selectionStart2D;
    private TwoDimensional.Position selectionEnd2D;
    private final EditableStyledDocument<S> content;
    private final S initialStyle;
    private final BiConsumer<Text, S> applyStyle;
    private final boolean preserveStyle;
    private final Guardian omniGuardian;

    @Override
    public final boolean isEditable() {
        return this.editable.get();
    }

    @Override
    public final void setEditable(boolean value) {
        this.editable.set(value);
    }

    @Override
    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    @Override
    public final boolean isWrapText() {
        return this.wrapText.get();
    }

    @Override
    public final void setWrapText(boolean value) {
        this.wrapText.set(value);
    }

    @Override
    public final BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setUndoManager(UndoManagerFactory undoManagerFactory) {
        this.undoManager.close();
        this.undoManager = this.preserveStyle ? this.createRichUndoManager(undoManagerFactory) : this.createPlainUndoManager(undoManagerFactory);
    }

    public final StyleableObjectProperty<Font> fontProperty() {
        return this.font;
    }

    public final void setFont(Font value) {
        this.font.setValue((Object)value);
    }

    public final Font getFont() {
        return (Font)this.font.getValue();
    }

    public void setPopupWindow(PopupWindow popup) {
        this.popupWindow.set((Object)popup);
    }

    public PopupWindow getPopupWindow() {
        return (PopupWindow)this.popupWindow.get();
    }

    public ObjectProperty<PopupWindow> popupWindowProperty() {
        return this.popupWindow;
    }

    @Deprecated
    public void setPopupAtCaret(PopupWindow popup) {
        this.popupWindow.set((Object)popup);
    }

    @Deprecated
    public PopupWindow getPopupAtCaret() {
        return (PopupWindow)this.popupWindow.get();
    }

    @Deprecated
    public ObjectProperty<PopupWindow> popupAtCaretProperty() {
        return this.popupWindow;
    }

    public void setPopupAnchorOffset(Point2D offset) {
        this.popupAnchorOffset.set((Object)offset);
    }

    public Point2D getPopupAnchorOffset() {
        return (Point2D)this.popupAnchorOffset.get();
    }

    public ObjectProperty<Point2D> popupAnchorOffsetProperty() {
        return this.popupAnchorOffset;
    }

    public void setPopupAnchorAdjustment(UnaryOperator<Point2D> f) {
        this.popupAnchorAdjustment.set(f);
    }

    public UnaryOperator<Point2D> getPopupAnchorAdjustment() {
        return (UnaryOperator)this.popupAnchorAdjustment.get();
    }

    public ObjectProperty<UnaryOperator<Point2D>> popupAnchorAdjustmentProperty() {
        return this.popupAnchorAdjustment;
    }

    public void setPopupAlignment(PopupAlignment pos) {
        this.popupAlignment.set((Object)pos);
    }

    public PopupAlignment getPopupAlignment() {
        return (PopupAlignment)((Object)this.popupAlignment.get());
    }

    public ObjectProperty<PopupAlignment> popupAlignmentProperty() {
        return this.popupAlignment;
    }

    public void setMouseOverTextDelay(Duration delay) {
        this.mouseOverTextDelay.set((Object)delay);
    }

    public Duration getMouseOverTextDelay() {
        return (Duration)this.mouseOverTextDelay.get();
    }

    public ObjectProperty<Duration> mouseOverTextDelayProperty() {
        return this.mouseOverTextDelay;
    }

    public void setParagraphGraphicFactory(IntFunction<? extends Node> factory) {
        this.paragraphGraphicFactory.set(factory);
    }

    public IntFunction<? extends Node> getParagraphGraphicFactory() {
        return (IntFunction)this.paragraphGraphicFactory.get();
    }

    public ObjectProperty<IntFunction<? extends Node>> paragraphGraphicFactoryProperty() {
        return this.paragraphGraphicFactory;
    }

    public void setUseInitialStyleForInsertion(boolean value) {
        this.content.useInitialStyleForInsertion.set(value);
    }

    public boolean getUseInitialStyleForInsertion() {
        return this.content.useInitialStyleForInsertion.get();
    }

    public BooleanProperty useInitialStyleForInsertionProperty() {
        return this.content.useInitialStyleForInsertion;
    }

    @Override
    public final String getText() {
        return (String)this.text.getValue();
    }

    @Override
    public final ObservableValue<String> textProperty() {
        return this.text;
    }

    @Override
    public final StyledDocument<S> getDocument() {
        return this.content.snapshot();
    }

    @Override
    public final int getLength() {
        return this.length.get();
    }

    @Override
    public final ObservableIntegerValue lengthProperty() {
        return this.length;
    }

    @Override
    public final int getCaretPosition() {
        return this.caretPosition.get();
    }

    @Override
    public final ObservableIntegerValue caretPositionProperty() {
        return this.caretPosition;
    }

    @Override
    public final int getAnchor() {
        return this.anchor.get();
    }

    @Override
    public final ObservableIntegerValue anchorProperty() {
        return this.anchor;
    }

    @Override
    public final IndexRange getSelection() {
        return (IndexRange)this.selection.getValue();
    }

    @Override
    public final ObservableValue<IndexRange> selectionProperty() {
        return this.selection;
    }

    @Override
    public final String getSelectedText() {
        return this.selectedText.get();
    }

    @Override
    public final ObservableStringValue selectedTextProperty() {
        return this.selectedText;
    }

    @Override
    public final int getCurrentParagraph() {
        return this.currentParagraph.get();
    }

    @Override
    public final ObservableIntegerValue currentParagraphProperty() {
        return this.currentParagraph;
    }

    @Override
    public final int getCaretColumn() {
        return this.caretColumn.get();
    }

    @Override
    public final ObservableIntegerValue caretColumnProperty() {
        return this.caretColumn;
    }

    @Override
    public ObservableList<Paragraph<S>> getParagraphs() {
        return this.paragraphs;
    }

    public Indicator beingUpdatedProperty() {
        return this.beingUpdated;
    }

    public boolean isBeingUpdated() {
        return this.beingUpdated.isOn();
    }

    @Override
    public final EventStream<PlainTextChange> plainTextChanges() {
        return this.plainTextChanges;
    }

    @Override
    public final EventStream<RichTextChange<S>> richChanges() {
        return this.richTextChanges;
    }

    public StyledTextArea(S initialStyle, BiConsumer<Text, S> applyStyle) {
        this(initialStyle, applyStyle, true);
    }

    public <C> StyledTextArea(S initialStyle, BiConsumer<Text, S> applyStyle, boolean preserveStyle) {
        this.initialStyle = initialStyle;
        this.applyStyle = applyStyle;
        this.preserveStyle = preserveStyle;
        this.content = new EditableStyledDocument<S>(initialStyle);
        this.paragraphs = Collections.wrap(this.content.getParagraphs());
        this.text = Binding.wrap(this.content.textProperty());
        this.length = IntegerBinding.wrap((ObservableValue)this.content.lengthProperty());
        this.plainTextChanges = this.content.plainTextChanges().pausable();
        this.richTextChanges = this.content.richChanges().pausable();
        this.undoManager = preserveStyle ? this.createRichUndoManager(UndoManagerFactory.unlimitedHistoryFactory()) : this.createPlainUndoManager(UndoManagerFactory.unlimitedHistoryFactory());
        MonadicBinding caretPosition2D = EasyBind.map((ObservableValue)this.internalCaretPosition, p -> this.content.offsetToPosition(p.intValue(), TwoDimensional.Bias.Forward));
        this.paragraphs.addListener(arg_0 -> StyledTextArea.lambda$new$7((javafx.beans.binding.Binding)caretPosition2D, arg_0));
        this.currentParagraph = IntegerBinding.wrap((ObservableValue)EasyBind.map((ObservableValue)caretPosition2D, p -> p.getMajor()));
        this.caretColumn = IntegerBinding.wrap((ObservableValue)EasyBind.map((ObservableValue)caretPosition2D, p -> p.getMinor()));
        this.selectionStart2D = this.position(0, 0);
        this.selectionEnd2D = this.position(0, 0);
        this.internalSelection.addListener(obs -> {
            IndexRange sel = (IndexRange)this.internalSelection.get();
            this.selectionStart2D = this.offsetToPosition(sel.getStart(), TwoDimensional.Bias.Forward);
            this.selectionEnd2D = sel.getLength() == 0 ? this.selectionStart2D : this.selectionStart2D.offsetBy(sel.getLength(), TwoDimensional.Bias.Backward);
        });
        this.selectedText = new StringBinding(){
            {
                this.bind(new Observable[]{StyledTextArea.this.internalSelection, StyledTextArea.this.content.textProperty()});
            }

            protected String computeValue() {
                return StyledTextArea.this.content.getText((IndexRange)StyledTextArea.this.internalSelection.get());
            }
        };
        Guardian[] guardianArray = new Guardian[12];
        guardianArray[0] = this.beingUpdated;
        guardianArray[1] = this.text;
        guardianArray[2] = this.length;
        guardianArray[3] = this.caretPosition;
        guardianArray[4] = this.anchor;
        guardianArray[5] = this.selection;
        guardianArray[6] = this.selectedText;
        guardianArray[7] = this.currentParagraph;
        guardianArray[8] = this.caretColumn;
        guardianArray[9] = () -> this.plainTextChanges.suspend();
        guardianArray[10] = () -> this.richTextChanges.suspend();
        guardianArray[11] = this.paragraphs;
        this.omniGuardian = Guardian.combine((Guardian[])guardianArray);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getStyleClass().add((Object)"styled-text-area");
    }

    @Override
    public final String getText(int start, int end) {
        return this.content.getText(start, end);
    }

    @Override
    public String getText(int paragraph) {
        return ((Paragraph)this.paragraphs.get(paragraph)).toString();
    }

    public Paragraph<S> getParagraph(int index) {
        return (Paragraph)this.paragraphs.get(index);
    }

    @Override
    public StyledDocument<S> subDocument(int start, int end) {
        return this.content.subSequence(start, end);
    }

    @Override
    public StyledDocument<S> subDocument(int paragraphIndex) {
        return this.content.subDocument(paragraphIndex);
    }

    public IndexRange getParagraphSelection(int paragraph) {
        int startPar = this.selectionStart2D.getMajor();
        int endPar = this.selectionEnd2D.getMajor();
        if (paragraph < startPar || paragraph > endPar) {
            return EMPTY_RANGE;
        }
        int start = paragraph == startPar ? this.selectionStart2D.getMinor() : 0;
        int end = paragraph == endPar ? this.selectionEnd2D.getMinor() : ((Paragraph)this.paragraphs.get(paragraph)).length();
        this.getSelection();
        return new IndexRange(start, end);
    }

    public S getStyleOfChar(int index) {
        return this.content.getStyleOfChar(index);
    }

    public S getStyleAtPosition(int position) {
        return this.content.getStyleAtPosition(position);
    }

    public IndexRange getStyleRangeAtPosition(int position) {
        return this.content.getStyleRangeAtPosition(position);
    }

    public StyleSpans<S> getStyleSpans(int from, int to) {
        return this.content.getStyleSpans(from, to);
    }

    public StyleSpans<S> getStyleSpans(IndexRange range) {
        return this.getStyleSpans(range.getStart(), range.getEnd());
    }

    public S getStyleOfChar(int paragraph, int index) {
        return this.content.getStyleOfChar(paragraph, index);
    }

    public S getStyleAtPosition(int paragraph, int position) {
        return this.content.getStyleOfChar(paragraph, position);
    }

    public IndexRange getStyleRangeAtPosition(int paragraph, int position) {
        return this.content.getStyleRangeAtPosition(paragraph, position);
    }

    public StyleSpans<S> getStyleSpans(int paragraph) {
        return this.content.getStyleSpans(paragraph);
    }

    public StyleSpans<S> getStyleSpans(int paragraph, int from, int to) {
        return this.content.getStyleSpans(paragraph, from, to);
    }

    public StyleSpans<S> getStyleSpans(int paragraph, IndexRange range) {
        return this.getStyleSpans(paragraph, range.getStart(), range.getEnd());
    }

    @Override
    public TwoDimensional.Position position(int row, int col) {
        return this.content.position(row, col);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int charOffset, TwoDimensional.Bias bias) {
        return this.content.offsetToPosition(charOffset, bias);
    }

    public void setStyle(int from, int to, S style) {
        try (Guard g = this.omniGuardian.guard();){
            this.content.setStyle(from, to, style);
        }
    }

    public void setStyle(int paragraph, S style) {
        try (Guard g = this.omniGuardian.guard();){
            this.content.setStyle(paragraph, style);
        }
    }

    public void setStyle(int paragraph, int from, int to, S style) {
        try (Guard g = this.omniGuardian.guard();){
            this.content.setStyle(paragraph, from, to, style);
        }
    }

    public void setStyleSpans(int from, StyleSpans<? extends S> styleSpans) {
        try (Guard g = this.omniGuardian.guard();){
            this.content.setStyleSpans(from, styleSpans);
        }
    }

    public void setStyleSpans(int paragraph, int from, StyleSpans<? extends S> styleSpans) {
        try (Guard g = this.omniGuardian.guard();){
            this.content.setStyleSpans(paragraph, from, styleSpans);
        }
    }

    public void clearStyle(int from, int to) {
        this.setStyle(from, to, this.initialStyle);
    }

    public void clearStyle(int paragraph) {
        this.setStyle(paragraph, this.initialStyle);
    }

    public void clearStyle(int paragraph, int from, int to) {
        this.setStyle(paragraph, from, to, this.initialStyle);
    }

    @Override
    public void replaceText(int start, int end, String text) {
        try (Guard g = this.omniGuardian.guard();){
            start = Utils.clamp((int)0, (int)start, (int)this.getLength());
            end = Utils.clamp((int)0, (int)end, (int)this.getLength());
            this.content.replaceText(start, end, text);
            int newCaretPos = start + text.length();
            this.selectRange(newCaretPos, newCaretPos);
        }
    }

    @Override
    public void replace(int start, int end, StyledDocument<S> replacement) {
        try (Guard g = this.omniGuardian.guard();){
            start = Utils.clamp((int)0, (int)start, (int)this.getLength());
            end = Utils.clamp((int)0, (int)end, (int)this.getLength());
            this.content.replace(start, end, replacement);
            int newCaretPos = start + replacement.length();
            this.selectRange(newCaretPos, newCaretPos);
        }
    }

    @Override
    public void selectRange(int anchor, int caretPosition) {
        try (Guard g = this.guard(new Guardian[]{this.caretPosition, this.currentParagraph, this.caretColumn, this.anchor, this.selection, this.selectedText});){
            this.internalCaretPosition.set(Utils.clamp((int)0, (int)caretPosition, (int)this.getLength()));
            this.anchor.set(Utils.clamp((int)0, (int)anchor, (int)this.getLength()));
            this.internalSelection.set((Object)IndexRange.normalize((int)this.getAnchor(), (int)this.getCaretPosition()));
        }
    }

    @Override
    public void positionCaret(int pos) {
        try (Guard g = this.guard(new Guardian[]{this.caretPosition, this.currentParagraph, this.caretColumn});){
            this.internalCaretPosition.set(pos);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return Skins.createSimpleSkin(this, area -> new StyledTextAreaVisual<S>(area, this.applyStyle), StyledTextAreaBehavior::new);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        List superMetaData = super.getControlCssMetaData();
        List<CssMetaData> myMetaData = Arrays.asList(this.font.getCssMetaData());
        ArrayList res = new ArrayList(superMetaData.size() + myMetaData.size());
        res.addAll(superMetaData);
        res.addAll(myMetaData);
        return res;
    }

    private UndoManager createPlainUndoManager(UndoManagerFactory factory) {
        Consumer<PlainTextChange> apply = change -> this.replaceText(change.getPosition(), change.getPosition() + ((String)change.getRemoved()).length(), (String)change.getInserted());
        Consumer<PlainTextChange> undo = change -> this.replaceText(change.getPosition(), change.getPosition() + ((String)change.getInserted()).length(), (String)change.getRemoved());
        BiFunction<PlainTextChange, PlainTextChange, Optional> merge = (change1, change2) -> change1.mergeWith(change2);
        return factory.create(this.plainTextChanges(), apply, undo, merge);
    }

    private UndoManager createRichUndoManager(UndoManagerFactory factory) {
        Consumer<RichTextChange> apply = change -> this.replace(change.getPosition(), change.getPosition() + ((StyledDocument)change.getRemoved()).length(), (StyledDocument)change.getInserted());
        Consumer<RichTextChange> undo = change -> this.replace(change.getPosition(), change.getPosition() + ((StyledDocument)change.getInserted()).length(), (StyledDocument)change.getRemoved());
        BiFunction<RichTextChange, RichTextChange, Optional> merge = (change1, change2) -> change1.mergeWith(change2);
        return factory.create(this.richChanges(), apply, undo, merge);
    }

    private Guard guard(Guardian ... guardians) {
        return Guardian.combine((Guardian[])new Guardian[]{this.beingUpdated, Guardian.combine((Guardian[])guardians)}).guard();
    }

    private static /* synthetic */ void lambda$new$7(javafx.beans.binding.Binding binding, Observable obs) {
        binding.invalidate();
    }
}

