/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.Optional;

public abstract class TextChange<S extends CharSequence, Self extends TextChange<S, Self>> {
    protected final int position;
    protected final S removed;
    protected final S inserted;

    public TextChange(int position, S removed, S inserted) {
        this.position = position;
        this.removed = removed;
        this.inserted = inserted;
    }

    public int getPosition() {
        return this.position;
    }

    public S getRemoved() {
        return this.removed;
    }

    public S getInserted() {
        return this.inserted;
    }

    protected abstract S concat(S var1, S var2);

    protected abstract S sub(S var1, int var2, int var3);

    protected abstract Self create(int var1, S var2, S var3);

    public Optional<Self> mergeWith(Self latter) {
        if (((TextChange)latter).position == this.position + this.inserted.length()) {
            S removedText = this.concat(this.removed, ((TextChange)latter).removed);
            S addedText = this.concat(this.inserted, ((TextChange)latter).inserted);
            return Optional.of(this.create(this.position, removedText, addedText));
        }
        if (((TextChange)latter).position + ((TextChange)latter).removed.length() == this.position + this.inserted.length()) {
            if (this.position <= ((TextChange)latter).position) {
                S addedText = this.concat(this.sub(this.inserted, 0, ((TextChange)latter).position - this.position), ((TextChange)latter).inserted);
                return Optional.of(this.create(this.position, this.removed, addedText));
            }
            S removedText = this.concat(this.sub(((TextChange)latter).removed, 0, this.position - ((TextChange)latter).position), this.removed);
            return Optional.of(this.create(((TextChange)latter).position, removedText, ((TextChange)latter).inserted));
        }
        return Optional.empty();
    }
}

