/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import org.fxmisc.richtext.TwoDimensional;

public class TwoLevelNavigator
implements TwoDimensional {
    private final IntSupplier elemCount;
    private final IntUnaryOperator elemLength;

    public TwoLevelNavigator(IntSupplier elemCount, IntUnaryOperator elemLength) {
        this.elemCount = elemCount;
        this.elemLength = elemLength;
    }

    @Override
    public TwoDimensional.Position position(int major, int minor) {
        return new Pos(major, minor);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int offset, TwoDimensional.Bias bias) {
        return this.position(0, 0).offsetBy(offset, bias);
    }

    private class Pos
    implements TwoDimensional.Position {
        private final int major;
        private final int minor;

        private Pos(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public String toString() {
            return "(" + this.major + ", " + this.minor + ")";
        }

        @Override
        public boolean sameAs(TwoDimensional.Position other) {
            return this.getTargetObject() == other.getTargetObject() && this.major == other.getMajor() && this.minor == other.getMinor();
        }

        @Override
        public TwoDimensional getTargetObject() {
            return TwoLevelNavigator.this;
        }

        @Override
        public int getMajor() {
            return this.major;
        }

        @Override
        public int getMinor() {
            return this.minor;
        }

        @Override
        public TwoDimensional.Position clamp() {
            if (this.major == TwoLevelNavigator.this.elemCount.getAsInt() - 1) {
                int elemLen = TwoLevelNavigator.this.elemLength.applyAsInt(this.major);
                if (this.minor < elemLen) {
                    return this;
                }
                return new Pos(this.major, elemLen - 1);
            }
            return this;
        }

        @Override
        public TwoDimensional.Position offsetBy(int offset, TwoDimensional.Bias bias) {
            if (offset > 0) {
                return this.forward(offset, bias);
            }
            if (offset < 0) {
                return this.backward(-offset, bias);
            }
            if (this.minor == 0 && this.major > 1 && bias == TwoDimensional.Bias.Backward) {
                return new Pos(this.major - 1, TwoLevelNavigator.this.elemLength.applyAsInt(this.major - 1));
            }
            if (this.minor == TwoLevelNavigator.this.elemLength.applyAsInt(this.major) && this.major < TwoLevelNavigator.this.elemCount.getAsInt() - 1 && bias == TwoDimensional.Bias.Forward) {
                return new Pos(this.major + 1, 0);
            }
            return this;
        }

        @Override
        public int toOffset() {
            int offset = 0;
            for (int i = 0; i < this.major; ++i) {
                offset += TwoLevelNavigator.this.elemLength.applyAsInt(i);
            }
            return offset + this.minor;
        }

        private TwoDimensional.Position forward(int offset, TwoDimensional.Bias bias) {
            offset += this.minor;
            int major = this.major;
            int curElemLength = TwoLevelNavigator.this.elemLength.applyAsInt(major);
            int elemCount = TwoLevelNavigator.this.elemCount.getAsInt();
            while (major < elemCount - 1) {
                if (offset < curElemLength || offset == curElemLength && bias == TwoDimensional.Bias.Backward) {
                    return new Pos(major, offset);
                }
                offset -= curElemLength;
                curElemLength = TwoLevelNavigator.this.elemLength.applyAsInt(++major);
            }
            return new Pos(elemCount - 1, offset);
        }

        private TwoDimensional.Position backward(int offset, TwoDimensional.Bias bias) {
            int minor = this.minor;
            int major = this.major;
            while (major > 0) {
                if (offset < minor || offset == minor && bias == TwoDimensional.Bias.Forward) {
                    return new Pos(major, minor - offset);
                }
                offset -= minor;
                minor = TwoLevelNavigator.this.elemLength.applyAsInt(--major);
            }
            if (offset < minor) {
                return new Pos(0, minor - offset);
            }
            return new Pos(0, 0);
        }
    }
}

