/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.skin;

import com.sun.javafx.binding.ExpressionHelper;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.util.Duration;

final class BooleanPulse
extends BooleanExpression {
    private ExpressionHelper<Boolean> listenerHelper;
    private final Timeline timeline;
    private boolean currentValue;

    public BooleanPulse(Duration duration) {
        this(duration, true);
    }

    public BooleanPulse(Duration duration, boolean initialValue) {
        this.currentValue = initialValue;
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        this.timeline.getKeyFrames().add((Object)new KeyFrame(duration, event -> this.toggle(), new KeyValue[0]));
    }

    public void start() {
        this.timeline.play();
    }

    public void start(boolean initialValue) {
        if (this.currentValue != initialValue) {
            this.toggle();
        }
        this.timeline.play();
    }

    public void stop() {
        this.timeline.stop();
    }

    public void stop(boolean terminalValue) {
        this.timeline.stop();
        if (this.currentValue != terminalValue) {
            this.toggle();
        }
    }

    private void toggle() {
        this.currentValue = !this.currentValue;
        ExpressionHelper.fireValueChangedEvent(this.listenerHelper);
    }

    public boolean get() {
        return this.currentValue;
    }

    public void addListener(ChangeListener<? super Boolean> listener) {
        this.listenerHelper = ExpressionHelper.addListener(this.listenerHelper, (ObservableValue)this, listener);
    }

    public void removeListener(ChangeListener<? super Boolean> listener) {
        this.listenerHelper = ExpressionHelper.removeListener(this.listenerHelper, listener);
    }

    public void addListener(InvalidationListener listener) {
        this.listenerHelper = ExpressionHelper.addListener(this.listenerHelper, (ObservableValue)this, (InvalidationListener)listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.listenerHelper = ExpressionHelper.removeListener(this.listenerHelper, (InvalidationListener)listener);
    }
}

