/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.skin;

import com.sun.javafx.tk.Toolkit;
import java.util.function.Function;
import javafx.event.EventType;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

class KeyBinding<A> {
    private final KeyCode code;
    private final String character;
    private final EventType<KeyEvent> eventType;
    private final Function<KeyEvent, A> actionFactory;
    private Boolean shift = false;
    private Boolean ctrl = false;
    private Boolean alt = false;
    private Boolean meta = false;

    public KeyBinding(KeyCode code, A action) {
        this(code, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED, (KeyEvent e) -> action);
    }

    public KeyBinding(KeyCode code, Function<KeyEvent, A> actionFactory) {
        this(code, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED, actionFactory);
    }

    public KeyBinding(KeyCode code, EventType<KeyEvent> type, A action) {
        this(code, type, (KeyEvent e) -> action);
    }

    public KeyBinding(KeyCode code, EventType<KeyEvent> type, Function<KeyEvent, A> actionFactory) {
        this.code = code;
        this.character = null;
        this.eventType = type;
        this.actionFactory = actionFactory;
    }

    public KeyBinding(String character, EventType<KeyEvent> type, A action) {
        this(character, type, (KeyEvent e) -> action);
    }

    public KeyBinding(String character, EventType<KeyEvent> type, Function<KeyEvent, A> actionFactory) {
        this.code = null;
        this.character = character;
        this.eventType = type;
        this.actionFactory = actionFactory;
    }

    public KeyBinding<A> shift() {
        return this.shift(true);
    }

    public KeyBinding<A> shift(Boolean value) {
        this.shift = value;
        return this;
    }

    public KeyBinding<A> ctrl() {
        return this.ctrl(true);
    }

    public KeyBinding<A> ctrl(Boolean value) {
        this.ctrl = value;
        return this;
    }

    public KeyBinding<A> alt() {
        return this.alt(true);
    }

    public KeyBinding<A> alt(Boolean value) {
        this.alt = value;
        return this;
    }

    public KeyBinding<A> meta() {
        return this.meta(true);
    }

    public KeyBinding<A> meta(Boolean value) {
        this.meta = value;
        return this;
    }

    public KeyBinding<A> shortcut() {
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT: {
                return this.shift();
            }
            case CONTROL: {
                return this.ctrl();
            }
            case ALT: {
                return this.alt();
            }
            case META: {
                return this.meta();
            }
        }
        return this;
    }

    public final KeyCode getCode() {
        return this.code;
    }

    public final EventType<KeyEvent> getType() {
        return this.eventType;
    }

    public final A getAction(KeyEvent event) {
        return this.actionFactory.apply(event);
    }

    public final Boolean getShift() {
        return this.shift;
    }

    public final Boolean getCtrl() {
        return this.ctrl;
    }

    public final Boolean getAlt() {
        return this.alt;
    }

    public final Boolean getMeta() {
        return this.meta;
    }

    public int getSpecificity(KeyEvent event) {
        int s = 0;
        if (this.character != null) {
            if (this.character.equals(event.getCharacter())) {
                ++s;
            } else {
                return 0;
            }
        }
        if (this.code != null) {
            if (this.code == event.getCode()) {
                ++s;
            } else {
                return 0;
            }
        }
        if (this.shift != null) {
            if (this.shift.booleanValue() == event.isShiftDown()) {
                ++s;
            } else {
                return 0;
            }
        }
        if (this.ctrl != null) {
            if (this.ctrl.booleanValue() == event.isControlDown()) {
                ++s;
            } else {
                return 0;
            }
        }
        if (this.alt != null) {
            if (this.alt.booleanValue() == event.isAltDown()) {
                ++s;
            } else {
                return 0;
            }
        }
        if (this.meta != null) {
            if (this.meta.booleanValue() == event.isMetaDown()) {
                ++s;
            } else {
                return 0;
            }
        }
        if (this.eventType != null) {
            if (this.eventType == event.getEventType()) {
                ++s;
            } else {
                return 0;
            }
        }
        return s;
    }

    public String toString() {
        return "KeyBinding [code=" + this.code + ", shift=" + this.shift + ", ctrl=" + this.ctrl + ", alt=" + this.alt + ", meta=" + this.meta + ", type=" + this.eventType + "]";
    }
}

