/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.skin;

import com.sun.javafx.scene.text.HitInfo;
import java.time.Duration;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.skin.ParagraphText;
import org.fxmisc.richtext.util.MouseStationaryHelper;
import org.reactfx.EventStream;
import org.reactfx.util.Either;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;

class ParagraphBox<S>
extends Region {
    private final ParagraphText<S> text;
    private final ObjectProperty<IntFunction<? extends Node>> graphicFactory = new SimpleObjectProperty(null);
    private final MonadicBinding<Node> graphic;
    private final BooleanProperty wrapText = new SimpleBooleanProperty(false);
    private final IntegerProperty index;

    public ObjectProperty<IntFunction<? extends Node>> graphicFactoryProperty() {
        return this.graphicFactory;
    }

    public BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    public IntegerProperty indexProperty() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index.set(index);
    }

    public int getIndex() {
        return this.index.get();
    }

    public ParagraphBox(int index, Paragraph<S> par, BiConsumer<Text, S> applyStyle) {
        this.wrapText.addListener((obs, old, w) -> this.requestLayout());
        this.getStyleClass().add((Object)"paragraph-box");
        this.text = new ParagraphText<S>(par, applyStyle);
        this.index = new SimpleIntegerProperty(index);
        this.getChildren().add(this.text);
        this.graphic = EasyBind.combine(this.graphicFactory, (ObservableValue)this.index, (f, i) -> f != null ? (Node)f.apply(i.intValue()) : null);
        this.graphic.addListener((obs, oldG, newG) -> {
            if (oldG != null) {
                this.getChildren().remove(oldG);
            }
            if (newG != null) {
                this.getChildren().add(newG);
            }
        });
    }

    public Property<Boolean> caretVisibleProperty() {
        return this.text.caretVisibleProperty();
    }

    public Property<Paint> highlightFillProperty() {
        return this.text.highlightFillProperty();
    }

    public Property<Paint> highlightTextFillProperty() {
        return this.text.highlightTextFillProperty();
    }

    public Property<Number> caretPositionProperty() {
        return this.text.caretPositionProperty();
    }

    public Property<IndexRange> selectionProperty() {
        return this.text.selectionProperty();
    }

    Paragraph<S> getParagraph() {
        return this.text.getParagraph();
    }

    public EventStream<Either<Tuple2<Point2D, Integer>, Object>> stationaryIndices(Duration delay) {
        EventStream<Either<Point2D, Void>> stationaryEvents = new MouseStationaryHelper((Node)this).events(delay);
        EventStream hits = stationaryEvents.filterMap(Either::asLeft).filterMap(pos -> this.hit((Point2D)pos).map(hit -> Tuples.t((Object)pos, (Object)hit.getCharIndex())));
        EventStream stops = stationaryEvents.filterMap(Either::isRight, Either::getRight);
        return hits.or(stops);
    }

    public Optional<HitInfo> hit(MouseEvent e) {
        return this.hit(e.getX(), e.getY());
    }

    public double getCaretOffsetX() {
        this.layout();
        return this.text.getCaretOffsetX();
    }

    public int getLineCount() {
        this.layout();
        return this.text.getLineCount();
    }

    public int getCurrentLineIndex() {
        this.layout();
        return this.text.currentLineIndex();
    }

    public Bounds getCaretBounds() {
        this.layout();
        Bounds b = this.text.getCaretBounds();
        return this.text.localToParent(b);
    }

    public Bounds getCaretBoundsOnScreen() {
        this.layout();
        return this.text.getCaretBoundsOnScreen();
    }

    public Optional<Bounds> getSelectionBoundsOnScreen() {
        this.layout();
        return this.text.getSelectionBoundsOnScreen();
    }

    protected double computeMinWidth(double ignoredHeight) {
        return this.computePrefWidth(-1.0);
    }

    protected double computePrefWidth(double ignoredHeight) {
        Insets insets = this.getInsets();
        return this.wrapText.get() ? 0.0 : this.getGraphicWidth() + this.text.prefWidth(-1.0) + insets.getLeft() + insets.getRight();
    }

    protected double computePrefHeight(double width) {
        Insets insets = this.getInsets();
        return this.text.prefHeight(width) + insets.getTop() + insets.getBottom();
    }

    protected void layoutChildren() {
        Bounds bounds = this.getLayoutBounds();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double layoutX = this.getLayoutX();
        double graphicWidth = this.getGraphicWidth();
        this.text.resizeRelocate(graphicWidth, 0.0, w - graphicWidth, h);
        this.graphic.ifPresent(g -> g.resizeRelocate(-layoutX, 0.0, graphicWidth, h));
    }

    double getGraphicWidth() {
        return this.graphic.getOpt().map(g -> g.prefWidth(-1.0)).orElse(0.0);
    }

    Optional<HitInfo> hitText(double x, int line) {
        return this.text.hit(x, line);
    }

    Optional<HitInfo> hitText(double x, double y) {
        return this.text.hit(x, y);
    }

    private Optional<HitInfo> hit(Point2D pos) {
        return this.hit(pos.getX(), pos.getY());
    }

    private Optional<HitInfo> hit(double x, double y) {
        Point2D onScreen = this.localToScreen(x, y);
        Point2D inText = this.text.screenToLocal(onScreen);
        return this.text.hit(inText.getX(), inText.getY());
    }
}

