/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.skin;

import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.text.PrismTextLayout;
import com.sun.javafx.text.TextLine;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BiConsumer;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.control.IndexRange;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.StyledText;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TwoDimensional;
import org.fxmisc.richtext.TwoLevelNavigator;

class ParagraphText<S>
extends TextFlow {
    private static Method mGetTextLayout;
    private static Method mGetLines;
    private final ObjectProperty<Paint> highlightTextFill = new SimpleObjectProperty((Object)Color.WHITE);
    private final IntegerProperty caretPosition = new SimpleIntegerProperty(0);
    private final NumberBinding clampedCaretPosition;
    private final ObjectProperty<IndexRange> selection = new SimpleObjectProperty((Object)StyledTextArea.EMPTY_RANGE);
    private final Paragraph<S> paragraph;
    private final Path caretShape = new Path();
    private final Path selectionShape = new Path();

    public ObjectProperty<Paint> highlightTextFillProperty() {
        return this.highlightTextFill;
    }

    public IntegerProperty caretPositionProperty() {
        return this.caretPosition;
    }

    public void setCaretPosition(int pos) {
        this.caretPosition.set(pos);
    }

    public ObjectProperty<IndexRange> selectionProperty() {
        return this.selection;
    }

    public void setSelection(IndexRange sel) {
        this.selection.set((Object)sel);
    }

    public ParagraphText(Paragraph<S> par, BiConsumer<Text, S> applyStyle) {
        this.paragraph = par;
        this.getStyleClass().add((Object)"paragraph-text");
        this.clampedCaretPosition = Bindings.min((ObservableNumberValue)this.caretPosition, (int)this.paragraph.length());
        this.clampedCaretPosition.addListener((obs, oldPos, newPos) -> this.requestLayout());
        this.selection.addListener((obs, old, sel) -> this.requestLayout());
        MonadicBinding leftInset = EasyBind.map((ObservableValue)this.insetsProperty(), ins -> ins.getLeft());
        MonadicBinding rightInset = EasyBind.map((ObservableValue)this.insetsProperty(), ins -> ins.getTop());
        this.selectionShape.setManaged(false);
        this.selectionShape.setVisible(true);
        this.selectionShape.setFill((Paint)Color.DODGERBLUE);
        this.selectionShape.setStrokeWidth(0.0);
        this.selectionShape.layoutXProperty().bind((ObservableValue)leftInset);
        this.selectionShape.layoutYProperty().bind((ObservableValue)rightInset);
        this.getChildren().add((Object)this.selectionShape);
        this.caretShape.setManaged(false);
        this.caretShape.setStrokeWidth(1.0);
        this.caretShape.layoutXProperty().bind((ObservableValue)leftInset);
        this.caretShape.layoutYProperty().bind((ObservableValue)rightInset);
        this.getChildren().add((Object)this.caretShape);
        for (StyledText<S> segment : par.getSegments()) {
            Text t = new Text(segment.toString());
            t.setTextOrigin(VPos.TOP);
            t.getStyleClass().add((Object)"text");
            applyStyle.accept(t, segment.getStyle());
            t.impl_selectionFillProperty().bind((ObservableValue)t.fillProperty());
            this.getChildren().add((Object)t);
        }
    }

    public Paragraph<S> getParagraph() {
        return this.paragraph;
    }

    public BooleanProperty caretVisibleProperty() {
        return this.caretShape.visibleProperty();
    }

    public ObjectProperty<Paint> highlightFillProperty() {
        return this.selectionShape.fillProperty();
    }

    Optional<HitInfo> hit(double x, int lineIndex) {
        return this.hit(x, this.getLineCenter(lineIndex));
    }

    Optional<HitInfo> hit(double x, double y) {
        if (this.paragraph.length() == 0) {
            return Optional.empty();
        }
        TextLayout textLayout = this.textLayout();
        HitInfo hit = textLayout.getHitInfo((float)x, (float)y);
        if (hit.getCharIndex() == this.paragraph.length() - 1) {
            PathElement[] elems = textLayout.getCaretShape(this.paragraph.length(), true, 0.0f, 0.0f);
            Path caret = new Path(elems);
            if (x > caret.getBoundsInLocal().getMinX()) {
                return Optional.empty();
            }
            return Optional.of(hit);
        }
        return Optional.of(hit);
    }

    public double getCaretOffsetX() {
        this.layout();
        Bounds bounds = this.caretShape.getLayoutBounds();
        return (bounds.getMinX() + bounds.getMaxX()) / 2.0;
    }

    public Bounds getCaretBounds() {
        this.layout();
        return this.caretShape.getBoundsInParent();
    }

    public Bounds getCaretBoundsOnScreen() {
        this.layout();
        Bounds localBounds = this.caretShape.getBoundsInLocal();
        return this.caretShape.localToScreen(localBounds);
    }

    public Optional<Bounds> getSelectionBoundsOnScreen() {
        if (((IndexRange)this.selection.get()).getLength() == 0) {
            return Optional.empty();
        }
        this.layout();
        Bounds localBounds = this.selectionShape.getBoundsInLocal();
        return Optional.of(this.selectionShape.localToScreen(localBounds));
    }

    public int getLineCount() {
        return this.getLines().length;
    }

    public int currentLineIndex() {
        TextLine[] lines = this.getLines();
        TwoLevelNavigator navigator = new TwoLevelNavigator(() -> lines.length, i -> lines[i].getLength());
        return navigator.offsetToPosition(this.clampedCaretPosition.intValue(), TwoDimensional.Bias.Forward).getMajor();
    }

    private float getLineCenter(int index) {
        return this.getLineY(index) + this.getLines()[index].getBounds().getHeight() / 2.0f;
    }

    private float getLineY(int index) {
        TextLine[] lines = this.getLines();
        float spacing = (float)this.getLineSpacing();
        float lineY = 0.0f;
        for (int i = 0; i < index; ++i) {
            lineY += lines[i].getBounds().getHeight() + spacing;
        }
        return lineY;
    }

    private TextLayout textLayout() {
        return (TextLayout)ParagraphText.invoke(mGetTextLayout, (Object)this, new Object[0]);
    }

    private TextLine[] getLines() {
        return (TextLine[])ParagraphText.invoke(mGetLines, this.textLayout(), new Object[0]);
    }

    private static Object invoke(Method m, Object obj, Object ... args) {
        try {
            return m.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateCaretShape() {
        Object[] shape = this.textLayout().getCaretShape(this.clampedCaretPosition.intValue(), true, 0.0f, 0.0f);
        this.caretShape.getElements().setAll(shape);
    }

    private void updateSelectionShape() {
        int start = ((IndexRange)this.selection.get()).getStart();
        int end = ((IndexRange)this.selection.get()).getEnd();
        Object[] shape = this.textLayout().getRange(start, end, 1, 0.0f, 0.0f);
        this.selectionShape.getElements().setAll(shape);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.updateCaretShape();
        this.updateSelectionShape();
    }

    static {
        try {
            mGetTextLayout = TextFlow.class.getDeclaredMethod("getTextLayout", new Class[0]);
            mGetLines = PrismTextLayout.class.getDeclaredMethod("getLines", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        mGetTextLayout.setAccessible(true);
        mGetLines.setAccessible(true);
    }
}

