/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.text.HitInfo;
import java.util.Optional;
import java.util.function.Function;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.scene.control.IndexRange;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TwoDimensional;
import org.fxmisc.richtext.skin.Action;
import org.fxmisc.richtext.skin.EditAction;
import org.fxmisc.richtext.skin.KeyBinding;
import org.fxmisc.richtext.skin.KeyBindings;
import org.fxmisc.richtext.skin.ParagraphBox;
import org.fxmisc.richtext.skin.StyledTextAreaVisual;
import org.fxmisc.richtext.skin.VerticalNavigation;
import org.fxmisc.richtext.util.skin.Behavior;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.Tuples;

public class StyledTextAreaBehavior
implements Behavior {
    private final StyledTextArea<?> area;
    private final StyledTextAreaVisual<?> visual;
    private final Subscription subscription;
    private DragState dragSelection = DragState.NO_DRAG;
    private double targetCaretOffset = -1.0;

    public void clearTargetCaretOffset() {
        this.targetCaretOffset = -1.0;
    }

    private double getTargetCaretOffset() {
        if (this.targetCaretOffset == -1.0) {
            this.targetCaretOffset = this.visual.getCaretOffsetX();
        }
        return this.targetCaretOffset;
    }

    public StyledTextAreaBehavior(StyledTextArea<?> styledTextArea, StyledTextAreaVisual<?> visual) {
        this.area = styledTextArea;
        this.visual = visual;
        this.subscription = Subscription.multi((Subscription[])new Subscription[]{visual.cellMouseEvents().subscribe(pair -> pair.exec(this::handleMouseEvent)), EventStreams.eventsOf(this.area, (EventType)MouseEvent.ANY).subscribe(this::handleMouseEvent), EventStreams.eventsOf(this.area, (EventType)KeyEvent.ANY).subscribe(this::handleKeyEvent)});
    }

    @Override
    public void dispose() {
        this.subscription.unsubscribe();
    }

    private void handleKeyEvent(KeyEvent e) {
        this.actionForEvent(e).ifPresent(action -> {
            this.callAction((Action)action);
            e.consume();
        });
    }

    private Optional<Action> actionForEvent(KeyEvent e) {
        return KeyBindings.BINDINGS.stream().map(b -> Tuples.t((Object)b, (Object)b.getSpecificity(e))).filter(t -> (Integer)t._2 > 0).reduce((a, b) -> (Integer)a._2 > (Integer)b._2 ? a : b).map(t -> (Action)((KeyBinding)t._1).getAction(e));
    }

    private void callAction(Action action) {
        if (action.isEdit() && !this.area.isEditable()) {
            return;
        }
        if (!action.isVerticalNavigation()) {
            this.clearTargetCaretOffset();
        }
        action.accept(this);
    }

    private void keyTyped(KeyEvent event) {
        if (event.isControlDown() || event.isAltDown() || event.isMetaDown()) {
            return;
        }
        String text = event.getCharacter();
        int n = text.length();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (StyledTextAreaBehavior.isLegal(text.charAt(i))) continue;
            return;
        }
        this.area.replaceSelection(text);
    }

    private static boolean isLegal(char c) {
        return !Character.isISOControl(c) || c == '\t';
    }

    private void deleteBackward() {
        IndexRange selection = this.area.getSelection();
        if (selection.getLength() == 0) {
            this.area.deletePreviousChar();
        } else {
            this.area.replaceSelection("");
        }
    }

    private void deleteForward() {
        IndexRange selection = this.area.getSelection();
        if (selection.getLength() == 0) {
            this.area.deleteNextChar();
        } else {
            this.area.replaceSelection("");
        }
    }

    private void left() {
        IndexRange sel = this.area.getSelection();
        if (sel.getLength() == 0) {
            this.area.previousChar(NavigationActions.SelectionPolicy.CLEAR);
        } else {
            this.area.moveTo(sel.getStart(), NavigationActions.SelectionPolicy.CLEAR);
        }
    }

    private void right() {
        IndexRange sel = this.area.getSelection();
        if (sel.getLength() == 0) {
            this.area.nextChar(NavigationActions.SelectionPolicy.CLEAR);
        } else {
            this.area.moveTo(sel.getEnd(), NavigationActions.SelectionPolicy.CLEAR);
        }
    }

    private void selectLeft() {
        this.area.previousChar(NavigationActions.SelectionPolicy.ADJUST);
    }

    private void selectRight() {
        this.area.nextChar(NavigationActions.SelectionPolicy.ADJUST);
    }

    private void leftWord(NavigationActions.SelectionPolicy selectionPolicy) {
        this.area.previousWord(selectionPolicy);
    }

    private void rightWord(NavigationActions.SelectionPolicy selectionPolicy) {
        this.area.nextWord(selectionPolicy);
    }

    private void selectWord() {
        this.area.previousWord(NavigationActions.SelectionPolicy.CLEAR);
        this.area.nextWord(NavigationActions.SelectionPolicy.ADJUST);
    }

    private void deletePreviousWord() {
        int end = this.area.getCaretPosition();
        if (end > 0) {
            this.area.previousWord(NavigationActions.SelectionPolicy.CLEAR);
            int start = this.area.getCaretPosition();
            this.area.replaceText(start, end, "");
        }
    }

    private void deleteNextWord() {
        int start = this.area.getCaretPosition();
        if (start < this.area.getLength()) {
            this.area.nextWord(NavigationActions.SelectionPolicy.CLEAR);
            int end = this.area.getCaretPosition();
            this.area.replaceText(start, end, "");
        }
    }

    private void downLines(int nLines, NavigationActions.SelectionPolicy selectionPolicy) {
        TwoDimensional.Position targetLine;
        TwoDimensional.Position currentLine = this.visual.currentLine();
        if (!currentLine.sameAs(targetLine = currentLine.offsetBy(nLines, TwoDimensional.Bias.Forward).clamp())) {
            int newCaretPos = this.visual.getInsertionIndex(this.getTargetCaretOffset(), targetLine);
            this.area.moveTo(newCaretPos, selectionPolicy);
        }
    }

    private void previousLine(NavigationActions.SelectionPolicy selectionPolicy) {
        this.downLines(-1, selectionPolicy);
    }

    private void nextLine(NavigationActions.SelectionPolicy selectionPolicy) {
        this.downLines(1, selectionPolicy);
    }

    private void previousPage(NavigationActions.SelectionPolicy selectionPolicy) {
        this.visual.followCaret();
        double height = this.visual.getViewportHeight();
        Bounds caretBounds = this.visual.getCaretBounds().get();
        double caretMidY = caretBounds.getMinY() + caretBounds.getHeight() / 2.0;
        int newCaretPos = this.visual.getInsertionIndex(this.getTargetCaretOffset(), caretMidY - height);
        this.visual.show(-height);
        this.area.moveTo(newCaretPos, selectionPolicy);
    }

    private void nextPage(NavigationActions.SelectionPolicy selectionPolicy) {
        this.visual.followCaret();
        double height = this.visual.getViewportHeight();
        Bounds caretBounds = this.visual.getCaretBounds().get();
        double caretMidY = caretBounds.getMinY() + caretBounds.getHeight() / 2.0;
        int newCaretPos = this.visual.getInsertionIndex(this.getTargetCaretOffset(), caretMidY + height);
        this.visual.show(2.0 * height);
        this.area.moveTo(newCaretPos, selectionPolicy);
    }

    private void handleMouseEvent(MouseEvent e) {
        if (e.getEventType() == MouseEvent.MOUSE_PRESSED && e.getButton() == MouseButton.PRIMARY) {
            this.area.requestFocus();
            this.area.end(NavigationActions.SelectionPolicy.CLEAR);
            e.consume();
        }
    }

    private void handleMouseEvent(ParagraphBox<?> cell, MouseEvent e) {
        if (e.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.mousePressed(cell, e);
            e.consume();
        } else if (e.getEventType() == MouseEvent.DRAG_DETECTED) {
            cell.getScene().startFullDrag();
            this.dragDetected(e);
            e.consume();
        } else if (e.getEventType() == MouseDragEvent.MOUSE_DRAG_OVER) {
            this.mouseDragOver(cell, (MouseDragEvent)e);
            e.consume();
        } else if (e.getEventType() == MouseDragEvent.MOUSE_DRAG_RELEASED) {
            this.mouseDragReleased(cell, (MouseDragEvent)e);
            e.consume();
        } else if (e.getEventType() == MouseEvent.MOUSE_RELEASED) {
            this.mouseReleased(cell, e);
            e.consume();
        }
    }

    private void mousePressed(ParagraphBox<?> cell, MouseEvent e) {
        if (this.area.isDisabled()) {
            return;
        }
        this.area.requestFocus();
        switch (e.getButton()) {
            case PRIMARY: {
                this.leftPress(cell, e);
                break;
            }
        }
    }

    private void leftPress(ParagraphBox<?> cell, MouseEvent e) {
        HitInfo hit = this.hitCell(cell, e);
        if (e.isShiftDown()) {
            this.area.moveTo(hit.getInsertionIndex(), PlatformUtil.isMac() ? NavigationActions.SelectionPolicy.EXTEND : NavigationActions.SelectionPolicy.ADJUST);
        } else {
            switch (e.getClickCount()) {
                case 1: {
                    this.firstLeftPress(hit);
                    break;
                }
                case 2: {
                    this.selectWord();
                    break;
                }
                case 3: {
                    this.area.selectLine();
                    break;
                }
            }
        }
    }

    private void firstLeftPress(HitInfo hit) {
        this.clearTargetCaretOffset();
        IndexRange selection = this.area.getSelection();
        if (selection.getLength() != 0 && hit.getCharIndex() >= selection.getStart() && hit.getCharIndex() < selection.getEnd()) {
            this.dragSelection = DragState.POTENTIAL_DRAG;
        } else {
            this.dragSelection = DragState.NO_DRAG;
            this.area.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.CLEAR);
        }
    }

    private void dragDetected(MouseEvent e) {
        if (this.dragSelection == DragState.POTENTIAL_DRAG) {
            this.dragSelection = DragState.DRAG;
        }
    }

    private void mouseDragOver(ParagraphBox<?> cell, MouseDragEvent e) {
        if (this.area.isDisabled()) {
            return;
        }
        if (e.getButton() != MouseButton.PRIMARY || e.isMiddleButtonDown() || e.isSecondaryButtonDown()) {
            return;
        }
        HitInfo hit = this.hitCell(cell, (MouseEvent)e);
        if (this.dragSelection == DragState.DRAG) {
            this.area.positionCaret(hit.getInsertionIndex());
        } else {
            this.area.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.ADJUST);
        }
    }

    private void mouseReleased(ParagraphBox<?> cell, MouseEvent e) {
        switch (this.dragSelection) {
            case POTENTIAL_DRAG: {
                HitInfo hit = this.hitCell(cell, e);
                this.area.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.CLEAR);
                break;
            }
        }
        this.dragSelection = DragState.NO_DRAG;
    }

    private void mouseDragReleased(ParagraphBox<?> cell, MouseDragEvent e) {
        if (this.area.isDisabled()) {
            return;
        }
        if (this.dragSelection == DragState.DRAG) {
            HitInfo hit = this.hitCell(cell, (MouseEvent)e);
            this.area.moveSelectedText(hit.getInsertionIndex());
        }
    }

    private HitInfo hitCell(ParagraphBox<?> cell, MouseEvent e) {
        int cellIdx = cell.getIndex();
        int cellOffset = this.area.position(cellIdx, 0).toOffset();
        return cell.hit(e).map(hit -> {
            hit.setCharIndex(hit.getCharIndex() + cellOffset);
            return hit;
        }).orElseGet(() -> StyledTextAreaBehavior.leadingEdgeOf(cellOffset + cell.getParagraph().length()));
    }

    private static HitInfo leadingEdgeOf(int charIdx) {
        HitInfo hit = new HitInfo();
        hit.setCharIndex(charIdx);
        hit.setLeading(true);
        return hit;
    }

    private static enum DragState {
        NO_DRAG,
        POTENTIAL_DRAG,
        DRAG;

    }

    static final class Actions {
        public static final Action Left = rec$ -> StyledTextAreaBehavior.access$1500((StyledTextAreaBehavior)rec$);
        public static final Action Right = rec$ -> StyledTextAreaBehavior.access$1400((StyledTextAreaBehavior)rec$);
        public static final Action SelectLeft = rec$ -> StyledTextAreaBehavior.access$1300((StyledTextAreaBehavior)rec$);
        public static final Action SelectRight = rec$ -> StyledTextAreaBehavior.access$1200((StyledTextAreaBehavior)rec$);
        public static final Action LeftWord = b -> StyledTextAreaBehavior.access$1100(b, NavigationActions.SelectionPolicy.CLEAR);
        public static final Action RightWord = b -> StyledTextAreaBehavior.access$1000(b, NavigationActions.SelectionPolicy.CLEAR);
        public static final Action SelectLeftWord = b -> StyledTextAreaBehavior.access$1100(b, NavigationActions.SelectionPolicy.ADJUST);
        public static final Action SelectRightWord = b -> StyledTextAreaBehavior.access$1000(b, NavigationActions.SelectionPolicy.ADJUST);
        public static final Action SelectLeftWordExtend = b -> StyledTextAreaBehavior.access$1100(b, NavigationActions.SelectionPolicy.EXTEND);
        public static final Action SelectRightWordExtend = b -> StyledTextAreaBehavior.access$1000(b, NavigationActions.SelectionPolicy.EXTEND);
        public static final Action LineStart = b -> ((StyledTextAreaBehavior)b).area.lineStart(NavigationActions.SelectionPolicy.CLEAR);
        public static final Action LineEnd = b -> ((StyledTextAreaBehavior)b).area.lineEnd(NavigationActions.SelectionPolicy.CLEAR);
        public static final Action SelectLineStart = b -> ((StyledTextAreaBehavior)b).area.lineStart(NavigationActions.SelectionPolicy.ADJUST);
        public static final Action SelectLineEnd = b -> ((StyledTextAreaBehavior)b).area.lineEnd(NavigationActions.SelectionPolicy.ADJUST);
        public static final Action SelectLineStartExtend = b -> ((StyledTextAreaBehavior)b).area.lineStart(NavigationActions.SelectionPolicy.EXTEND);
        public static final Action SelectLineEndExtend = b -> ((StyledTextAreaBehavior)b).area.lineEnd(NavigationActions.SelectionPolicy.EXTEND);
        public static final Action TextStart = b -> ((StyledTextAreaBehavior)b).area.start(NavigationActions.SelectionPolicy.CLEAR);
        public static final Action TextEnd = b -> ((StyledTextAreaBehavior)b).area.end(NavigationActions.SelectionPolicy.CLEAR);
        public static final Action SelectTextStart = b -> ((StyledTextAreaBehavior)b).area.start(NavigationActions.SelectionPolicy.ADJUST);
        public static final Action SelectTextEnd = b -> ((StyledTextAreaBehavior)b).area.end(NavigationActions.SelectionPolicy.ADJUST);
        public static final Action SelectTextStartExtend = b -> ((StyledTextAreaBehavior)b).area.start(NavigationActions.SelectionPolicy.EXTEND);
        public static final Action SelectTextEndExtend = b -> ((StyledTextAreaBehavior)b).area.end(NavigationActions.SelectionPolicy.EXTEND);
        public static final VerticalNavigation PreviousLine = b -> StyledTextAreaBehavior.access$900(b, NavigationActions.SelectionPolicy.CLEAR);
        public static final VerticalNavigation NextLine = b -> StyledTextAreaBehavior.access$800(b, NavigationActions.SelectionPolicy.CLEAR);
        public static final VerticalNavigation SelectPreviousLine = b -> StyledTextAreaBehavior.access$900(b, NavigationActions.SelectionPolicy.ADJUST);
        public static final VerticalNavigation SelectNextLine = b -> StyledTextAreaBehavior.access$800(b, NavigationActions.SelectionPolicy.ADJUST);
        public static final VerticalNavigation PreviousPage = b -> StyledTextAreaBehavior.access$700(b, NavigationActions.SelectionPolicy.CLEAR);
        public static final VerticalNavigation NextPage = b -> StyledTextAreaBehavior.access$600(b, NavigationActions.SelectionPolicy.CLEAR);
        public static final VerticalNavigation SelectPreviousPage = b -> StyledTextAreaBehavior.access$700(b, NavigationActions.SelectionPolicy.ADJUST);
        public static final VerticalNavigation SelectNextPage = b -> StyledTextAreaBehavior.access$600(b, NavigationActions.SelectionPolicy.ADJUST);
        public static final EditAction DeletePreviousChar = rec$ -> StyledTextAreaBehavior.access$500((StyledTextAreaBehavior)rec$);
        public static final EditAction DeleteNextChar = rec$ -> StyledTextAreaBehavior.access$400((StyledTextAreaBehavior)rec$);
        public static final EditAction DeletePreviousWord = rec$ -> StyledTextAreaBehavior.access$300((StyledTextAreaBehavior)rec$);
        public static final EditAction DeleteNextWord = rec$ -> StyledTextAreaBehavior.access$200((StyledTextAreaBehavior)rec$);
        public static final EditAction InsertNewLine = b -> ((StyledTextAreaBehavior)b).area.replaceSelection("\n");
        public static final EditAction InsertTab = b -> ((StyledTextAreaBehavior)b).area.replaceSelection("\t");
        public static final Function<KeyEvent, EditAction> InputCharacter = e -> b -> ((StyledTextAreaBehavior)b).keyTyped(e);
        public static final EditAction Cut = b -> ((StyledTextAreaBehavior)b).area.cut();
        public static final Action Copy = b -> ((StyledTextAreaBehavior)b).area.copy();
        public static final EditAction Paste = b -> ((StyledTextAreaBehavior)b).area.paste();
        public static final EditAction Undo = b -> ((StyledTextAreaBehavior)b).area.undo();
        public static final EditAction Redo = b -> ((StyledTextAreaBehavior)b).area.redo();
        public static final Action SelectAll = b -> ((StyledTextAreaBehavior)b).area.selectAll();
        public static final Action Unselect = b -> ((StyledTextAreaBehavior)b).area.deselect();
        public static final Action Consume = b -> {};

        Actions() {
        }
    }
}

