/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.skin;

import com.sun.javafx.scene.text.HitInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.PopupWindow;
import javafx.util.Duration;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.fxmisc.easybind.monadic.MonadicObservableValue;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.richtext.MouseOverTextEvent;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.PopupAlignment;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TwoDimensional;
import org.fxmisc.richtext.TwoLevelNavigator;
import org.fxmisc.richtext.skin.BooleanPulse;
import org.fxmisc.richtext.skin.CssProperties;
import org.fxmisc.richtext.skin.ParagraphBox;
import org.fxmisc.richtext.util.skin.SimpleVisual;
import org.reactfx.EventSource;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;

public class StyledTextAreaVisual<S>
implements SimpleVisual {
    private final StyleableObjectProperty<Paint> highlightFill = new CssProperties.HighlightFillProperty(this, (Paint)Color.DODGERBLUE);
    private final StyleableObjectProperty<Paint> highlightTextFill = new CssProperties.HighlightTextFillProperty(this, (Paint)Color.WHITE);
    private final EventStream<Tuple2<ParagraphBox<S>, MouseEvent>> cellMouseEvents;
    private final StyledTextArea<S> area;
    private Subscription subscriptions = () -> {};
    private final BooleanPulse caretPulse = new BooleanPulse(Duration.seconds((double)0.5));
    private final BooleanBinding caretVisible;
    private final VirtualFlow<Paragraph<S>, Cell<Paragraph<S>, ParagraphBox<S>>> virtualFlow;
    private final TwoLevelNavigator navigator;

    final EventStream<Tuple2<ParagraphBox<S>, MouseEvent>> cellMouseEvents() {
        return this.cellMouseEvents;
    }

    public StyledTextAreaVisual(StyledTextArea<S> styledTextArea, BiConsumer<Text, S> applyStyle) {
        this.area = styledTextArea;
        this.area.getStylesheets().add((Object)StyledTextAreaVisual.class.getResource("styled-text-area.css").toExternalForm());
        ObservableSet nonEmptyCells = FXCollections.observableSet((Object[])new ParagraphBox[0]);
        this.virtualFlow = VirtualFlow.createVertical(this.area.getParagraphs(), (index, par) -> {
            Cell cell = this.createCell((int)index, (Paragraph<S>)par, applyStyle);
            nonEmptyCells.add((Object)cell.getNode());
            return cell.beforeReset(() -> nonEmptyCells.remove((Object)cell.getNode())).afterUpdateItem((i, p) -> nonEmptyCells.add((Object)cell.getNode()));
        });
        IntSupplier cellCount = () -> this.area.getParagraphs().size();
        IntUnaryOperator cellLength = i -> ((ParagraphBox)this.virtualFlow.getCell(i).getNode()).getLineCount();
        this.navigator = new TwoLevelNavigator(cellCount, cellLength);
        EventStream areaDoneUpdating = this.area.beingUpdatedProperty().offs();
        EventStream caretPosDirty = EventStreams.invalidationsOf((Observable)this.area.caretPositionProperty());
        EventStream paragraphsDirty = EventStreams.invalidationsOf(this.area.getParagraphs());
        EventStream selectionDirty = EventStreams.invalidationsOf(this.area.selectionProperty());
        EventStream caretDirty = EventStreams.merge((EventStream[])new EventStream[]{caretPosDirty, paragraphsDirty, selectionDirty});
        EventSource positionPopupImpulse = new EventSource();
        this.subscribeTo(caretDirty.emitOn(areaDoneUpdating), x -> {
            this.followCaret();
            positionPopupImpulse.push(null);
        });
        this.manageSubscription(EventStreams.valuesOf((ObservableValue)this.area.focusedProperty()).subscribe(isFocused -> {
            if (isFocused.booleanValue()) {
                this.caretPulse.start(true);
            } else {
                this.caretPulse.stop(false);
            }
        }));
        this.manageSubscription(() -> this.caretPulse.stop());
        this.caretVisible = this.caretPulse.and((ObservableBooleanValue)this.area.focusedProperty()).and((ObservableBooleanValue)this.area.editableProperty()).and((ObservableBooleanValue)this.area.disabledProperty().not());
        this.manageBinding((Binding<?>)this.caretVisible);
        MonadicObservableValue userFunction = EasyBind.monadic(this.area.popupAnchorAdjustmentProperty());
        MonadicBinding userOffset = EasyBind.monadic(this.area.popupAnchorOffsetProperty()).map(offset -> anchor -> anchor.add(offset));
        MonadicBinding popupAnchorAdjustment = userFunction.orElse((ObservableValue)userOffset).orElse(UnaryOperator.identity());
        this.manageSubscription(EventStreams.combine((EventStream)EventStreams.valuesOf(this.area.popupWindowProperty()), (EventStream)EventStreams.valuesOf(this.area.popupAlignmentProperty()), (EventStream)EventStreams.valuesOf((ObservableValue)popupAnchorAdjustment)).repeatOn((EventStream)positionPopupImpulse).filter((w, al, adj) -> w != null).subscribe((w, al, adj) -> this.positionPopup((PopupWindow)w, (PopupAlignment)((Object)al), (UnaryOperator<Point2D>)adj)));
        EventStreams.valuesOf(this.area.mouseOverTextDelayProperty()).flatMap(delay -> delay != null ? this.mouseOverTextEvents((ObservableSet<ParagraphBox<S>>)nonEmptyCells, (java.time.Duration)delay) : EventStreams.never()).hook(evt -> Event.fireEvent(this.area, (Event)evt)).pin();
        this.cellMouseEvents = EventStreams.merge((ObservableSet)nonEmptyCells, c -> EventStreams.eventsOf((Node)c, (EventType)MouseEvent.ANY).map(e -> Tuples.t((Object)c, (Object)e)));
    }

    @Override
    public Node getNode() {
        return this.virtualFlow;
    }

    @Override
    public void dispose() {
        this.subscriptions.unsubscribe();
        this.virtualFlow.dispose();
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Arrays.asList(this.highlightFill.getCssMetaData(), this.highlightTextFill.getCssMetaData());
    }

    void show(double y) {
        this.virtualFlow.show(y);
    }

    void followCaret() {
        int parIdx = this.area.getCurrentParagraph();
        Cell cell = this.virtualFlow.getCell(parIdx);
        Bounds caretBounds = ((ParagraphBox)cell.getNode()).getCaretBounds();
        double graphicWidth = ((ParagraphBox)cell.getNode()).getGraphicWidth();
        Bounds region = StyledTextAreaVisual.extendLeft(caretBounds, graphicWidth);
        this.virtualFlow.show(cell, region);
    }

    Optional<Bounds> getCaretBounds() {
        return this.virtualFlow.getCellIfVisible(this.area.getCurrentParagraph()).map(c -> {
            Bounds cellBounds = ((ParagraphBox)c.getNode()).getCaretBounds();
            return this.virtualFlow.cellToViewport(c, cellBounds);
        });
    }

    double getCaretOffsetX() {
        int idx = this.area.getCurrentParagraph();
        return idx == -1 ? 0.0 : this.getCell(idx).getCaretOffsetX();
    }

    double getViewportHeight() {
        return this.virtualFlow.getViewportHeight();
    }

    int getInsertionIndex(double textX, TwoDimensional.Position targetLine) {
        int parIdx = targetLine.getMajor();
        ParagraphBox cell = (ParagraphBox)this.virtualFlow.getCell(parIdx).getNode();
        int parInsertionIndex = this.getCellInsertionIndex(cell, textX, targetLine.getMinor());
        return this.getParagraphOffset(parIdx) + parInsertionIndex;
    }

    int getInsertionIndex(double textX, double y) {
        VirtualFlow.HitInfo hit = this.virtualFlow.hit(y);
        if (hit.isBeforeCells()) {
            return 0;
        }
        if (hit.isAfterCells()) {
            return this.area.getLength();
        }
        int parIdx = hit.getCellIndex();
        ParagraphBox cell = (ParagraphBox)hit.getCell().getNode();
        double cellY = hit.getCellOffset();
        int parInsertionIndex = this.getCellInsertionIndex(cell, textX, cellY);
        return this.getParagraphOffset(parIdx) + parInsertionIndex;
    }

    TwoDimensional.Position currentLine() {
        int parIdx = this.area.getCurrentParagraph();
        Cell cell = this.virtualFlow.getCell(parIdx);
        int lineIdx = ((ParagraphBox)cell.getNode()).getCurrentLineIndex();
        return this.position(parIdx, lineIdx);
    }

    TwoDimensional.Position position(int par, int line) {
        return this.navigator.position(par, line);
    }

    private Cell<Paragraph<S>, ParagraphBox<S>> createCell(int index, Paragraph<S> paragraph, BiConsumer<Text, S> applyStyle) {
        final ParagraphBox<S> box = new ParagraphBox<S>(index, paragraph, applyStyle);
        box.highlightFillProperty().bind(this.highlightFill);
        box.highlightTextFillProperty().bind(this.highlightTextFill);
        box.wrapTextProperty().bind((ObservableValue)this.area.wrapTextProperty());
        box.graphicFactoryProperty().bind(this.area.paragraphGraphicFactoryProperty());
        final BooleanBinding hasCaret = Bindings.equal((ObservableNumberValue)box.indexProperty(), (ObservableNumberValue)this.area.currentParagraphProperty());
        final BooleanBinding cellCaretVisible = hasCaret.and((ObservableBooleanValue)this.caretVisible);
        box.caretVisibleProperty().bind((ObservableValue)cellCaretVisible);
        final org.fxmisc.easybind.Subscription caretPositionSub = EasyBind.when((ObservableValue)hasCaret).bind(box.caretPositionProperty(), (ObservableValue)this.area.caretColumnProperty());
        final ObjectBinding cellSelection = Bindings.createObjectBinding(() -> {
            int idx = box.getIndex();
            return idx != -1 ? this.area.getParagraphSelection(idx) : StyledTextArea.EMPTY_RANGE;
        }, (Observable[])new Observable[]{this.area.selectionProperty(), box.indexProperty()});
        box.selectionProperty().bind((ObservableValue)cellSelection);
        return new Cell<Paragraph<S>, ParagraphBox<S>>(){

            public ParagraphBox<S> getNode() {
                return box;
            }

            public void updateIndex(int index) {
                box.setIndex(index);
            }

            public void dispose() {
                box.highlightFillProperty().unbind();
                box.highlightTextFillProperty().unbind();
                box.wrapTextProperty().unbind();
                box.graphicFactoryProperty().unbind();
                box.caretVisibleProperty().unbind();
                cellCaretVisible.dispose();
                hasCaret.dispose();
                caretPositionSub.unsubscribe();
                box.selectionProperty().unbind();
                cellSelection.dispose();
            }
        };
    }

    private ParagraphBox<S> getCell(int index) {
        return (ParagraphBox)((Cell)this.virtualFlow.getCellIfVisible(index).get()).getNode();
    }

    private int getCellInsertionIndex(ParagraphBox<S> cell, double x, int line) {
        return cell.hitText(x, line).map(HitInfo::getInsertionIndex).orElse(cell.getParagraph().length());
    }

    private int getCellInsertionIndex(ParagraphBox<S> cell, double x, double y) {
        return cell.hitText(x, y).map(HitInfo::getInsertionIndex).orElse(cell.getParagraph().length());
    }

    private EventStream<MouseOverTextEvent> mouseOverTextEvents(ObservableSet<ParagraphBox<S>> cells, java.time.Duration delay) {
        return EventStreams.merge(cells, c -> c.stationaryIndices(delay).map(e -> (MouseOverTextEvent)((Object)((Object)((Object)e.unify(l -> (MouseOverTextEvent)((Object)((Object)((Object)((Object)l.map((pos, charIdx) -> MouseOverTextEvent.beginAt(c.localToScreen((Point2D)pos), this.getParagraphOffset(c.getIndex()) + charIdx)))))), r -> MouseOverTextEvent.end()))))));
    }

    private int getParagraphOffset(int parIdx) {
        return this.area.position(parIdx, 0).toOffset();
    }

    private void positionPopup(PopupWindow popup, PopupAlignment alignment, UnaryOperator<Point2D> adjustment) {
        Optional<Bounds> bounds = null;
        switch (alignment.getAnchorObject()) {
            case CARET: {
                bounds = this.getCaretBoundsOnScreen();
                break;
            }
            case SELECTION: {
                bounds = this.getSelectionBoundsOnScreen();
            }
        }
        bounds.ifPresent(b -> {
            double x = 0.0;
            double y = 0.0;
            switch (alignment.getHorizontalAlignment()) {
                case LEFT: {
                    x = b.getMinX();
                    break;
                }
                case H_CENTER: {
                    x = (b.getMinX() + b.getMaxX()) / 2.0;
                    break;
                }
                case RIGHT: {
                    x = b.getMaxX();
                }
            }
            switch (alignment.getVerticalAlignment()) {
                case TOP: {
                    y = b.getMinY();
                }
                case V_CENTER: {
                    y = (b.getMinY() + b.getMaxY()) / 2.0;
                    break;
                }
                case BOTTOM: {
                    y = b.getMaxY();
                }
            }
            Point2D anchor = (Point2D)adjustment.apply(new Point2D(x, y));
            popup.setAnchorX(anchor.getX());
            popup.setAnchorY(anchor.getY());
        });
    }

    private Optional<Bounds> getCaretBoundsOnScreen() {
        return this.virtualFlow.getCellIfVisible(this.area.getCurrentParagraph()).map(c -> ((ParagraphBox)c.getNode()).getCaretBoundsOnScreen());
    }

    private Optional<Bounds> getSelectionBoundsOnScreen() {
        IndexRange selection = this.area.getSelection();
        if (selection.getLength() == 0) {
            return this.getCaretBoundsOnScreen();
        }
        Bounds[] bounds = (Bounds[])this.virtualFlow.visibleCells().map(c -> ((ParagraphBox)c.getNode()).getSelectionBoundsOnScreen()).filter(opt -> opt.isPresent()).map(opt -> (Bounds)opt.get()).toArray(Bounds[]::new);
        if (bounds.length == 0) {
            return Optional.empty();
        }
        double minX = Stream.of(bounds).mapToDouble(Bounds::getMinX).min().getAsDouble();
        double maxX = Stream.of(bounds).mapToDouble(Bounds::getMaxX).max().getAsDouble();
        double minY = Stream.of(bounds).mapToDouble(Bounds::getMinY).min().getAsDouble();
        double maxY = Stream.of(bounds).mapToDouble(Bounds::getMaxY).max().getAsDouble();
        return Optional.of(new BoundingBox(minX, minY, maxX - minX, maxY - minY));
    }

    private <T> void subscribeTo(EventStream<T> src, Consumer<T> consumer) {
        this.manageSubscription(src.subscribe(consumer));
    }

    private void manageSubscription(Subscription subscription) {
        this.subscriptions = this.subscriptions.and(subscription);
    }

    private void manageBinding(Binding<?> binding) {
        this.subscriptions = this.subscriptions.and(() -> binding.dispose());
    }

    private static Bounds extendLeft(Bounds b, double w) {
        if (w == 0.0) {
            return b;
        }
        return new BoundingBox(b.getMinX() - w, b.getMinY(), b.getWidth() + w, b.getHeight());
    }
}

