/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.util.skin;

import java.lang.reflect.Method;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import org.fxmisc.richtext.util.skin.Visual;

public abstract class ComplexVisualBase<C extends Control>
implements Visual {
    private final C control;
    private final ObservableList<Node> children;

    public ComplexVisualBase(C control) {
        this.control = control;
        try {
            Method m = Control.class.getDeclaredMethod("getControlChildren", new Class[0]);
            m.setAccessible(true);
            this.children = (ObservableList)m.invoke(control, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public abstract void dispose();

    protected final C getControl() {
        return this.control;
    }

    protected ObservableList<Node> getChildren() {
        return this.children;
    }
}

