/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.util.concurrent.Exchanger;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.anno.JRubyClass;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.fiber.Fiber;
import org.jruby.ext.fiber.ThreadFiberState;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Fiber"})
public class ThreadFiber
extends Fiber {
    private final Exchanger<IRubyObject> exchanger = new Exchanger();
    private volatile ThreadFiberState state = ThreadFiberState.NOT_STARTED;

    public ThreadFiber(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @Override
    protected void initFiber(ThreadContext context) {
        final Ruby runtime = context.runtime;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ThreadContext context = runtime.getCurrentContext();
                context.setFiber(ThreadFiber.this);
                IRubyObject result2 = ThreadFiber.this.yield(context, context.nil);
                try {
                    result2 = result2 == RubyBasicObject.NEVER ? ThreadFiber.this.block.yieldSpecific(context) : ThreadFiber.this.block.yieldArray(context, result2, null, null);
                }
                catch (JumpException.RetryJump rtry) {
                    ThreadFiber.this.parent.raise(new IRubyObject[]{runtime.newSyntaxError("Invalid retry").getException()}, Block.NULL_BLOCK);
                }
                catch (JumpException.BreakJump brk) {
                    ThreadFiber.this.parent.raise(new IRubyObject[]{runtime.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, runtime.getNil(), "break from proc-closure").getException()}, Block.NULL_BLOCK);
                }
                catch (JumpException.ReturnJump ret) {
                    ThreadFiber.this.parent.raise(new IRubyObject[]{runtime.newLocalJumpError(RubyLocalJumpError.Reason.RETURN, runtime.getNil(), "unexpected return").getException()}, Block.NULL_BLOCK);
                }
                catch (RaiseException re) {
                    ThreadFiber.this.parent.raise(new IRubyObject[]{re.getException()}, Block.NULL_BLOCK);
                }
                finally {
                    ThreadFiber.this.state = ThreadFiberState.FINISHED;
                    try {
                        ThreadFiber.this.exchanger.exchange(result2);
                    }
                    catch (InterruptedException e) {}
                }
            }
        };
        context.runtime.getExecutor().submit(runnable);
        try {
            this.exchanger.exchange(context.nil);
        }
        catch (InterruptedException ie) {
            throw runtime.newConcurrencyError("interrupted while waiting for fiber to start");
        }
    }

    @Override
    protected IRubyObject resumeOrTransfer(ThreadContext context, IRubyObject arg2, boolean transfer2) {
        try {
            switch (this.state) {
                case NOT_STARTED: {
                    if (this.isRoot()) {
                        this.state = ThreadFiberState.RUNNING;
                        return arg2;
                    }
                    if (!this.isSameParentThread(context)) {
                        throw context.runtime.newFiberError("resuming fiber from different thread");
                    }
                    throw context.runtime.newRuntimeError("BUG: resume before fiber is started");
                }
                case YIELDED: {
                    if (!this.isSameParentThread(context)) {
                        throw context.runtime.newFiberError("resuming fiber from different thread");
                    }
                    if (!transfer2 && this.transferredTo != null) {
                        throw context.runtime.newFiberError("double resume");
                    }
                    if (transfer2) {
                        this.transferredFrom = (ThreadFiber)context.getFiber();
                        this.transferredFrom.transferredTo = this;
                    }
                    this.exchanger.exchange(arg2);
                    arg2 = this.exchanger.exchange(context.nil);
                    context.pollThreadEvents();
                    if (transfer2) {
                        if (!this.transferredFrom.isRoot()) {
                            arg2 = this.transferredFrom.yield(context, arg2);
                        }
                        this.transferredFrom.transferredTo = null;
                        this.transferredFrom = null;
                    }
                    return arg2;
                }
                case RUNNING: {
                    if (transfer2 && context.getFiber() == this) {
                        return arg2;
                    }
                    throw context.runtime.newFiberError("double resume");
                }
                case FINISHED: {
                    throw context.runtime.newFiberError("dead fiber called");
                }
            }
            throw context.runtime.newFiberError("fiber in an unknown state");
        }
        catch (OutOfMemoryError oome) {
            if (oome.getMessage().equals("unable to create new native thread")) {
                throw context.runtime.newThreadError("too many threads, can't create a new Fiber");
            }
            throw oome;
        }
        catch (InterruptedException ie) {
            throw context.runtime.newConcurrencyError("interrupted waiting for fiber");
        }
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject res) {
        try {
            this.state = ThreadFiberState.YIELDED;
            this.exchanger.exchange(res);
            res = this.exchanger.exchange(context.nil);
            context.pollThreadEvents();
            this.state = ThreadFiberState.RUNNING;
            return res;
        }
        catch (InterruptedException ie) {
            throw context.runtime.newConcurrencyError("interrupted while waiting for fiber to start");
        }
    }

    @Override
    public boolean isAlive() {
        return this.state != ThreadFiberState.FINISHED;
    }

    private boolean isSameParentThread(ThreadContext context) {
        return context.getThread() == this.parent || context.getFiber() != null && context.getFiber().getParentThread() == this.parent;
    }
}

