/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.Counter;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReceiveExceptionInstr;
import org.jruby.ir.instructions.ReceiveOptArgBase;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgBase;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.ruby19.ReceivePostReqdArgInstr;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.IRStaticScope;
import org.jruby.parser.IRStaticScopeFactory;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.jruby.util.unsafe.UnsafeFactory;

public class Interpreter {
    private static final Logger LOG = LoggerFactory.getLogger("Interpreter");
    private static int inlineCount = 0;
    private static int interpInstrsCount = 0;
    private static int codeModificationsCount = 0;
    private static int numCyclesWithNoModifications = 0;
    private static int globalThreadPollCount = 0;
    private static HashMap<IRScope, Counter> scopeThreadPollCounts = new HashMap();

    private static IRScope getEvalContainerScope(Ruby runtime, StaticScope evalScope) {
        IRScope containingIRScope = ((IRStaticScope)evalScope.getEnclosingScope()).getIRScope();
        if (containingIRScope == null) {
            containingIRScope = ((IRStaticScope)evalScope.getEnclosingScope().getEnclosingScope()).getIRScope();
        }
        return containingIRScope;
    }

    public static IRubyObject interpretCommonEval(Ruby runtime, String file2, int lineNumber, String backtraceName, RootNode rootNode, IRubyObject self2, Block block) {
        boolean is_1_9 = runtime.is1_9();
        if (is_1_9) {
            IRBuilder.setRubyVersion("1.9");
        }
        StaticScope ss = rootNode.getStaticScope();
        IRScope containingIRScope = Interpreter.getEvalContainerScope(runtime, ss);
        IREvalScript evalScript = IRBuilder.createIRBuilder(runtime.getIRManager(), is_1_9).buildEvalRoot(ss, containingIRScope, file2, lineNumber, rootNode);
        evalScript.prepareForInterpretation(false);
        ThreadContext context = runtime.getCurrentContext();
        Interpreter.runBeginEndBlocks(evalScript.getBeginBlocks(), context, self2, null);
        IRubyObject rv = evalScript.call(context, self2, evalScript.getStaticScope().getModule(), rootNode.getScope(), block, backtraceName);
        Interpreter.runBeginEndBlocks(evalScript.getEndBlocks(), context, self2, null);
        return rv;
    }

    public static IRubyObject interpretSimpleEval(Ruby runtime, String file2, int lineNumber, String backtraceName, Node node, IRubyObject self2) {
        return Interpreter.interpretCommonEval(runtime, file2, lineNumber, backtraceName, (RootNode)node, self2, Block.NULL_BLOCK);
    }

    public static IRubyObject interpretBindingEval(Ruby runtime, String file2, int lineNumber, String backtraceName, Node node, IRubyObject self2, Block block) {
        return Interpreter.interpretCommonEval(runtime, file2, lineNumber, backtraceName, (RootNode)node, self2, block);
    }

    public static void runBeginEndBlocks(List<IRClosure> beBlocks, ThreadContext context, IRubyObject self2, Object[] temp) {
        if (beBlocks == null) {
            return;
        }
        for (IRClosure b : beBlocks) {
            b.prepareForInterpretation(false);
            Block blk = (Block)new WrappedIRClosure(b).retrieve(context, self2, context.getCurrentScope(), temp);
            blk.yield(context, null);
        }
    }

    public static IRubyObject interpret(Ruby runtime, Node rootNode, IRubyObject self2) {
        IRScriptBody root;
        if (runtime.is1_9()) {
            IRBuilder.setRubyVersion("1.9");
        }
        if ((root = (IRScriptBody)IRBuilder.createIRBuilder(runtime.getIRManager(), runtime.is1_9()).buildRoot((RootNode)rootNode)).getStaticScope().getModule() == null) {
            root.getStaticScope().setModule(runtime.getObject());
        }
        RubyModule currModule = root.getStaticScope().getModule();
        IRStaticScopeFactory.newIRLocalScope(null).setModule(currModule);
        ThreadContext context = runtime.getCurrentContext();
        try {
            Interpreter.runBeginEndBlocks(root.getBeginBlocks(), context, self2, null);
            InterpretedIRMethod method2 = new InterpretedIRMethod(root, currModule);
            IRubyObject rv = method2.call(context, self2, currModule, "(root)", IRubyObject.NULL_ARRAY);
            Interpreter.runBeginEndBlocks(root.getEndBlocks(), context, self2, null);
            if (IRRuntimeHelpers.isDebug() || IRRuntimeHelpers.inProfileMode()) {
                LOG.info("-- Interpreted instructions: {}", interpInstrsCount);
            }
            return rv;
        }
        catch (IRBreakJump bj) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
    }

    private static void analyzeProfile() {
        numCyclesWithNoModifications = codeModificationsCount == 0 ? ++numCyclesWithNoModifications : 0;
        codeModificationsCount = 0;
        if (numCyclesWithNoModifications < 3) {
            return;
        }
        ArrayList<IRScope> scopes = new ArrayList<IRScope>(scopeThreadPollCounts.keySet());
        Collections.sort(scopes, new Comparator<IRScope>(){

            @Override
            public int compare(IRScope a, IRScope b) {
                float aCount = ((Counter)scopeThreadPollCounts.get((Object)a)).count;
                float bCount = ((Counter)scopeThreadPollCounts.get((Object)b)).count;
                if (aCount == bCount) {
                    return 0;
                }
                return aCount < bCount ? 1 : -1;
            }
        });
        HashSet<IRScope> hotScopes = new HashSet<IRScope>();
        int i2 = 0;
        float f = 0.0f;
        for (IRScope s2 : scopes) {
            Instr[] instrs;
            long sCount = Interpreter.scopeThreadPollCounts.get((Object)s2).count;
            float sPerc = (float)(sCount * 1000L / (long)globalThreadPollCount) / 10.0f;
            if (sPerc < 1.0f && ((instrs = s2.getInstrsForInterpretation()) == null || (float)instrs.length > 5.0f + sPerc * 10.0f)) continue;
            hotScopes.add(s2);
            f += sPerc;
            if (++i2 != 50 && !((double)f >= 99.0)) continue;
            break;
        }
        boolean revisitScope = false;
        Iterator hsIter = hotScopes.iterator();
        IRScope hs = null;
        block1: while (hsIter.hasNext()) {
            if (!revisitScope) {
                hs = (IRScope)hsIter.next();
            }
            revisitScope = false;
            boolean skip2 = false;
            boolean isHotClosure = hs instanceof IRClosure;
            IRScope hc = isHotClosure ? hs : null;
            hs = isHotClosure ? hs.getLexicalParent() : hs;
            for (BasicBlock b : hs.getCFG().getBasicBlocks()) {
                for (Instr instr : b.getInstrs()) {
                    InterpretedIRMethod dynMeth;
                    IRScope tgtMethod;
                    Instr[] instrs;
                    CachingCallSite ccs;
                    CallBase call2;
                    CallSite cs;
                    if (!(instr instanceof CallBase) || ((CallBase)instr).inliningBlocked() || (cs = (call2 = (CallBase)instr).getCallSite()) == null || !(cs instanceof CachingCallSite) || !(ccs = (CachingCallSite)cs).isOptimizable()) continue;
                    CacheEntry ce = ccs.getCache();
                    DynamicMethod tgt = ce.method;
                    if (!(tgt instanceof InterpretedIRMethod) || (instrs = (tgtMethod = (dynMeth = (InterpretedIRMethod)tgt).getIRMethod()).getInstrsForInterpretation()) == null || instrs.length > 150) continue;
                    RubyModule implClass = dynMeth.getImplementationClass();
                    int classToken = implClass.getGeneration();
                    String n = tgtMethod.getName();
                    boolean inlineCall = false;
                    if (isHotClosure) {
                        Operand clArg = call2.getClosureArg(null);
                        inlineCall = clArg instanceof WrappedIRClosure && ((WrappedIRClosure)clArg).getClosure() == hc;
                    } else if (hotScopes.contains(tgtMethod)) {
                        inlineCall = true;
                    }
                    if (!inlineCall) continue;
                    System.out.println("Inlining " + tgtMethod + " in " + hs + " @ instr " + instr);
                    hs.inlineMethod(tgtMethod, implClass, classToken, b, call2);
                    scopeThreadPollCounts.remove(isHotClosure ? hc : hs);
                    scopeThreadPollCounts.remove(tgtMethod);
                    ++inlineCount;
                    skip2 = true;
                    revisitScope = true;
                    break;
                }
                if (!skip2) continue;
                continue block1;
            }
        }
    }

    private static void outputProfileStats() {
        ArrayList<IRScope> scopes = new ArrayList<IRScope>(scopeThreadPollCounts.keySet());
        Collections.sort(scopes, new Comparator<IRScope>(){

            @Override
            public int compare(IRScope a, IRScope b) {
                float bCount;
                float aCount;
                int bden;
                int aden = a.getThreadPollInstrsCount();
                if (aden == 0) {
                    aden = 1;
                }
                if ((bden = b.getThreadPollInstrsCount()) == 0) {
                    bden = 1;
                }
                if ((aCount = (float)((Counter)scopeThreadPollCounts.get((Object)a)).count * (1.0f * (float)a.getInstrsForInterpretation().length / (float)aden)) == (bCount = (float)((Counter)scopeThreadPollCounts.get((Object)b)).count * (1.0f * (float)b.getInstrsForInterpretation().length / (float)bden))) {
                    return 0;
                }
                return aCount < bCount ? 1 : -1;
            }
        });
        LOG.info("------------------------", new Object[0]);
        LOG.info("Stats after " + globalThreadPollCount + " thread polls:", new Object[0]);
        LOG.info("------------------------", new Object[0]);
        LOG.info("# instructions: " + interpInstrsCount, new Object[0]);
        LOG.info("# code modifications in this period : " + codeModificationsCount, new Object[0]);
        LOG.info("------------------------", new Object[0]);
        int i2 = 0;
        float f1 = 0.0f;
        for (IRScope s2 : scopes) {
            long n = Interpreter.scopeThreadPollCounts.get((Object)s2).count;
            float p1 = (float)(n * 1000L / (long)globalThreadPollCount) / 10.0f;
            String msg = i2 + ". " + s2 + " [file:" + s2.getFileName() + ":" + s2.getLineNumber() + "] = " + n + "; (" + p1 + "%)";
            if (s2 instanceof IRClosure) {
                IRMethod m = s2.getNearestMethod();
                if (m != null) {
                    LOG.info(msg + " -- nearest enclosing method: " + m, new Object[0]);
                } else {
                    LOG.info(msg + " -- no enclosing method --", new Object[0]);
                }
            } else {
                LOG.info(msg, new Object[0]);
            }
            f1 += p1;
            if (++i2 != 20 && !((double)f1 >= 95.0)) continue;
            break;
        }
        codeModificationsCount = 0;
        if (globalThreadPollCount % 1000000 == 0) {
            System.out.println("---- resetting thread-poll counters ----");
            scopeThreadPollCounts = new HashMap();
            globalThreadPollCount = 0;
        }
    }

    private static IRubyObject interpret(ThreadContext context, IRubyObject self2, IRScope scope, Visibility visibility, RubyModule implClass, IRubyObject[] args2, Block block, Block.Type blockType) {
        int temporaryVariablesSize;
        boolean debug = IRRuntimeHelpers.isDebug();
        boolean profile = IRRuntimeHelpers.inProfileMode();
        Instr[] instrs = scope.getInstrsForInterpretation();
        if (instrs == null) {
            instrs = scope.prepareForInterpretation(blockType == Block.Type.LAMBDA);
        }
        Object[] temp = (temporaryVariablesSize = scope.getTemporaryVariableSize()) > 0 ? new Object[temporaryVariablesSize] : null;
        int n = instrs.length;
        int ipc = 0;
        Instr instr = null;
        Throwable exception2 = null;
        Ruby runtime = context.runtime;
        DynamicScope currDynScope = context.getCurrentScope();
        Counter tpCount = null;
        if (profile && (tpCount = scopeThreadPollCounts.get(scope)) == null) {
            tpCount = new Counter();
            scopeThreadPollCounts.put(scope, tpCount);
        }
        while (ipc < n) {
            instr = instrs[ipc];
            ++ipc;
            Operation operation = instr.getOperation();
            if (debug) {
                LOG.info("I: {}", instr);
                ++interpInstrsCount;
            } else if (profile) {
                if (operation.modifiesCode()) {
                    ++codeModificationsCount;
                }
                ++interpInstrsCount;
            }
            try {
                Variable resultVar = null;
                Object result2 = null;
                switch (operation) {
                    case JUMP: {
                        ipc = ((JumpInstr)instr).getJumpTarget().getTargetPC();
                        break;
                    }
                    case MODULE_GUARD: 
                    case JUMP_INDIRECT: 
                    case B_TRUE: 
                    case B_FALSE: 
                    case B_NIL: 
                    case B_UNDEF: 
                    case BEQ: 
                    case BNE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, self2, temp, ipc);
                        break;
                    }
                    case RECV_PRE_REQD_ARG: {
                        ReceiveArgBase ra = (ReceivePreReqdArgInstr)instr;
                        int argIndex = ra.getArgIndex();
                        result2 = argIndex < args2.length ? args2[argIndex] : context.nil;
                        resultVar = ra.getResult();
                        break;
                    }
                    case RECV_POST_REQD_ARG: {
                        ReceiveArgBase ra = (ReceivePostReqdArgInstr)instr;
                        result2 = ((ReceivePostReqdArgInstr)ra).receivePostReqdArg(args2);
                        if (result2 == null) {
                            result2 = context.nil;
                        }
                        resultVar = ra.getResult();
                        break;
                    }
                    case RECV_OPT_ARG: {
                        ReceiveArgBase ra = (ReceiveOptArgBase)instr;
                        result2 = ((ReceiveOptArgBase)ra).receiveOptArg(args2);
                        resultVar = ra.getResult();
                        break;
                    }
                    case RECV_REST_ARG: {
                        ReceiveArgBase ra = (ReceiveRestArgBase)instr;
                        result2 = ((ReceiveRestArgBase)ra).receiveRestArg(runtime, args2);
                        resultVar = ra.getResult();
                        break;
                    }
                    case RECV_CLOSURE: {
                        result2 = block == Block.NULL_BLOCK ? context.nil : runtime.newProc(Block.Type.PROC, block);
                        resultVar = ((ResultInstr)((Object)instr)).getResult();
                        break;
                    }
                    case RECV_EXCEPTION: {
                        ReceiveExceptionInstr rei = (ReceiveExceptionInstr)instr;
                        result2 = exception2 instanceof RaiseException && rei.checkType ? ((RaiseException)exception2).getException() : exception2;
                        resultVar = rei.getResult();
                        break;
                    }
                    case BREAK: {
                        BreakInstr bi = (BreakInstr)instr;
                        IRubyObject rv = (IRubyObject)bi.getReturnValue().retrieve(context, self2, currDynScope, temp);
                        return IRRuntimeHelpers.initiateBreak(context, scope, bi.getScopeToReturnTo(), rv, blockType);
                    }
                    case RETURN: {
                        return (IRubyObject)((ReturnBase)instr).getReturnValue().retrieve(context, self2, currDynScope, temp);
                    }
                    case NONLOCAL_RETURN: {
                        NonlocalReturnInstr ri = (NonlocalReturnInstr)instr;
                        IRubyObject rv = (IRubyObject)ri.getReturnValue().retrieve(context, self2, currDynScope, temp);
                        ipc = n;
                        if (!IRRuntimeHelpers.inLambda(blockType)) {
                            IRRuntimeHelpers.initiateNonLocalReturn(context, scope, ri.methodToReturnFrom, rv);
                        }
                        return rv;
                    }
                    case CHECK_ARITY: {
                        ((CheckArityInstr)instr).checkArity(runtime, args2.length);
                        break;
                    }
                    case PUSH_FRAME: {
                        context.preMethodFrameAndClass(implClass, scope.getName(), self2, block, scope.getStaticScope());
                        context.setCurrentVisibility(visibility);
                        break;
                    }
                    case PUSH_BINDING: {
                        currDynScope = DynamicScope.newDynamicScope(scope.getStaticScope());
                        context.pushScope(currDynScope);
                        break;
                    }
                    case POP_FRAME: {
                        context.popFrame();
                        context.popRubyClass();
                        break;
                    }
                    case POP_BINDING: {
                        context.popScope();
                        break;
                    }
                    case THREAD_POLL: {
                        if (profile) {
                            ++tpCount.count;
                            ++globalThreadPollCount;
                        }
                        context.callThreadPoll();
                        break;
                    }
                    case LINE_NUM: {
                        context.setLine(((LineNumberInstr)instr).lineNumber);
                        break;
                    }
                    case RUNTIME_HELPER: {
                        resultVar = ((ResultInstr)((Object)instr)).getResult();
                        result2 = ((RuntimeHelperCall)instr).callHelper(context, currDynScope, self2, temp, scope, blockType);
                        break;
                    }
                    case COPY: {
                        CopyInstr c = (CopyInstr)instr;
                        result2 = c.getSource().retrieve(context, self2, currDynScope, temp);
                        resultVar = ((ResultInstr)((Object)instr)).getResult();
                        break;
                    }
                    default: {
                        if (instr instanceof ResultInstr) {
                            resultVar = ((ResultInstr)((Object)instr)).getResult();
                        }
                        result2 = instr.interpret(context, currDynScope, self2, temp, block);
                    }
                }
                if (resultVar == null) continue;
                if (resultVar instanceof TemporaryVariable) {
                    temp[((TemporaryVariable)resultVar).offset] = result2;
                    continue;
                }
                LocalVariable lv = (LocalVariable)resultVar;
                currDynScope.setValue((IRubyObject)result2, lv.getLocation(), lv.getScopeDepth());
            }
            catch (Throwable t) {
                if (debug) {
                    LOG.info("in scope: " + scope + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                }
                int n2 = ipc = t instanceof Unrescuable ? scope.getEnsurerPC(instr) : scope.getRescuerPC(instr);
                if (debug) {
                    LOG.info("ipc for rescuer/ensurer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    UnsafeFactory.getUnsafe().throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(ThreadContext context, IRubyObject self2, IRScope scope, RubyModule clazz, IRubyObject[] args2, String name2, Block block, Block.Type blockType) {
        try {
            ThreadContext.pushBacktrace(context, name2, scope.getFileName(), context.getLine());
            IRubyObject iRubyObject = Interpreter.interpret(context, self2, scope, null, clazz, args2, block, blockType);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_BLOCK(ThreadContext context, IRubyObject self2, IRScope scope, IRubyObject[] args2, String name2, Block block, Block.Type blockType) {
        try {
            ThreadContext.pushBacktrace(context, name2, scope.getFileName(), context.getLine());
            IRubyObject iRubyObject = Interpreter.interpret(context, self2, scope, null, null, args2, block, blockType);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_METHOD(ThreadContext context, InterpretedIRMethod irMethod, IRubyObject self2, String name2, IRubyObject[] args2, Block block, Block.Type blockType, boolean isTraceable) {
        Ruby runtime = context.runtime;
        IRScope scope = irMethod.getIRMethod();
        RubyModule implClass = irMethod.getImplementationClass();
        Visibility viz = irMethod.getVisibility();
        boolean syntheticMethod = name2 == null || name2.equals("");
        try {
            if (!syntheticMethod) {
                ThreadContext.pushBacktrace(context, name2, scope.getFileName(), context.getLine());
            }
            if (isTraceable) {
                Interpreter.methodPreTrace(runtime, context, name2, implClass);
            }
            IRubyObject iRubyObject = Interpreter.interpret(context, self2, scope, viz, implClass, args2, block, blockType);
            return iRubyObject;
        }
        finally {
            if (isTraceable) {
                try {
                    Interpreter.methodPostTrace(runtime, context, name2, implClass);
                }
                finally {
                    if (!syntheticMethod) {
                        ThreadContext.popBacktrace(context);
                    }
                }
            } else if (!syntheticMethod) {
                ThreadContext.popBacktrace(context);
            }
        }
    }

    private static void methodPreTrace(Ruby runtime, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime.hasEventHooks()) {
            context.trace(RubyEvent.CALL, name2, implClass);
        }
    }

    private static void methodPostTrace(Ruby runtime, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime.hasEventHooks()) {
            context.trace(RubyEvent.RETURN, name2, implClass);
        }
    }
}

