/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class Binding {
    private final Frame frame;
    private final BacktraceElement backtrace;
    private final RubyModule klass;
    private Visibility visibility;
    private IRubyObject self;
    private final DynamicScope dynamicScope;
    private DynamicScope evalScope;
    private Binding evalScopeBinding = this;
    private DynamicScope dummyScope;

    public Binding(IRubyObject self2, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope, BacktraceElement backtrace2) {
        this.self = self2;
        this.frame = frame.duplicate();
        this.visibility = visibility;
        this.klass = klass;
        this.dynamicScope = dynamicScope;
        this.backtrace = backtrace2;
    }

    private Binding(IRubyObject self2, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope, BacktraceElement backtrace2, DynamicScope dummyScope) {
        this.self = self2;
        this.frame = frame;
        this.visibility = visibility;
        this.klass = klass;
        this.dynamicScope = dynamicScope;
        this.backtrace = backtrace2;
        this.dummyScope = dummyScope;
    }

    public Binding(Frame frame, RubyModule bindingClass, DynamicScope dynamicScope, BacktraceElement backtrace2) {
        this.self = frame.getSelf();
        this.frame = frame.duplicate();
        this.visibility = frame.getVisibility();
        this.klass = bindingClass;
        this.dynamicScope = dynamicScope;
        this.backtrace = backtrace2;
    }

    private Binding(Binding other) {
        this(other.self, other.frame.duplicate(), other.visibility, other.klass, other.dynamicScope, other.backtrace, other.dummyScope);
    }

    public Binding cloneForEval() {
        Binding clone = new Binding(this);
        clone.evalScopeBinding = this;
        return clone;
    }

    public Binding clone() {
        return new Binding(this);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject self2) {
        this.self = self2;
    }

    public DynamicScope getDynamicScope() {
        return this.dynamicScope;
    }

    public DynamicScope getDummyScope(StaticScope staticScope) {
        if (this.dummyScope == null || this.dummyScope.getStaticScope() != staticScope) {
            this.dummyScope = DynamicScope.newDummyScope(staticScope, this.dynamicScope);
            return this.dummyScope;
        }
        return this.dummyScope;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public RubyModule getKlass() {
        return this.klass;
    }

    public String getFile() {
        return this.backtrace.filename;
    }

    public void setFile(String file2) {
        this.backtrace.filename = file2;
    }

    public int getLine() {
        return this.backtrace.line;
    }

    public void setLine(int line) {
        this.backtrace.line = line;
    }

    public String getMethod() {
        return this.backtrace.method;
    }

    public void setMethod(String method2) {
        this.backtrace.method = method2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Binding)) {
            return false;
        }
        Binding bOther = (Binding)other;
        return this.self == bOther.self && this.dynamicScope == bOther.dynamicScope;
    }

    public final DynamicScope getEvalScope(Ruby runtime) {
        if (this.evalScopeBinding.evalScope == null) {
            DynamicScope parent = this.dynamicScope.getNextCapturedScope();
            this.evalScopeBinding.evalScope = parent != null && parent.getEvalScope(runtime) == this.dynamicScope ? this.dynamicScope : new ManyVarsDynamicScope(runtime.getStaticScopeFactory().newEvalScope(this.dynamicScope.getStaticScope()), this.dynamicScope);
        }
        return this.evalScopeBinding.evalScope;
    }
}

