/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context.register;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.ogm.MetaData;

public class TypeRegister {
    private final ConcurrentMap<Class<?>, Map<Long, Object>> register = new ConcurrentHashMap();

    public void remove(MetaData metaData, Class type, Long id) {
        Map entities = (Map)this.register.get(type);
        if (entities != null && type.getSuperclass() != null && metaData != null && metaData.classInfo(type.getSuperclass().getName()) != null && !type.getSuperclass().getName().equals("java.lang.Object")) {
            entities.remove(id);
            this.remove(metaData, type.getSuperclass(), id);
        }
    }

    public Map<Long, Object> get(Class<?> type) {
        return Collections.unmodifiableMap(this.objectMap(type));
    }

    public void clear() {
        this.register.clear();
    }

    public void add(MetaData metaData, Class type, Object entity, Long id) {
        this.objectMap(type).put(id, entity);
        if (type.getSuperclass() != null && metaData != null && metaData.classInfo(type.getSuperclass().getName()) != null && !type.getSuperclass().getName().equals("java.lang.Object")) {
            this.add(metaData, type.getSuperclass(), entity, id);
        }
        if (type.getInterfaces() != null && metaData != null) {
            for (Class<?> interfaceClass : type.getInterfaces()) {
                if (metaData.classInfo(interfaceClass.getName()) == null) continue;
                this.add(metaData, interfaceClass, entity, id);
            }
        }
    }

    public void delete(Class<?> type) {
        this.register.keySet().remove(type);
    }

    private Map<Long, Object> objectMap(Class<?> type) {
        Map objectMap = (Map)this.register.get(type);
        if (objectMap == null) {
            this.register.putIfAbsent(type, Collections.synchronizedMap(new HashMap()));
            objectMap = (Map)this.register.get(type);
        }
        return objectMap;
    }
}

