/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.pitest.coverage.CoverageSummary;
import org.pitest.functional.Option;
import org.pitest.functional.predicate.Predicate;
import org.pitest.maven.DependencyFilter;
import org.pitest.maven.GoalStrategy;
import org.pitest.maven.MojoToReportOptionsConverter;
import org.pitest.maven.RunPitStrategy;
import org.pitest.maven.SurefireConfigConverter;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.statistics.MutationStatistics;
import org.pitest.mutationtest.tooling.CombinedStatistics;
import org.pitest.plugin.ToolClasspathPlugin;
import org.slf4j.bridge.SLF4JBridgeHandler;
import uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4J;

public class AbstractPitMojo
extends AbstractMojo {
    protected final Predicate<Artifact> filter;
    protected final PluginServices plugins;
    @Parameter(property="targetClasses")
    protected ArrayList<String> targetClasses;
    @Parameter(property="targetTests")
    protected ArrayList<String> targetTests;
    @Parameter(property="excludedMethods")
    private ArrayList<String> excludedMethods;
    @Parameter(property="excludedClasses")
    private ArrayList<String> excludedClasses;
    @Parameter(property="avoidCallsTo")
    private ArrayList<String> avoidCallsTo;
    @Parameter(defaultValue="${project.build.directory}/pit-reports", property="reportsDirectory")
    private File reportsDirectory;
    @Parameter(property="historyOutputFile")
    private File historyOutputFile;
    @Parameter(property="historyInputFile")
    private File historyInputFile;
    @Parameter(defaultValue="false", property="withHistory")
    private boolean withHistory;
    @Parameter(defaultValue="-1", property="maxDependencyDistance")
    private int maxDependencyDistance;
    @Parameter(defaultValue="1", property="threads")
    private int threads;
    @Parameter(defaultValue="false", property="mutateStaticInitializers")
    private boolean mutateStaticInitializers;
    @Parameter(defaultValue="true", property="detectInlinedCode")
    private boolean detectInlinedCode;
    @Parameter(property="mutators")
    private ArrayList<String> mutators;
    @Parameter(defaultValue="1.25", property="timeoutFactor")
    private float timeoutFactor;
    @Parameter(defaultValue="3000", property="timeoutConstant")
    private long timeoutConstant;
    @Parameter(defaultValue="-1", property="maxMutationsPerClass")
    private int maxMutationsPerClass;
    @Parameter
    private ArrayList<String> jvmArgs;
    @Parameter(property="outputFormats")
    private ArrayList<String> outputFormats;
    @Parameter(defaultValue="false", property="verbose")
    private boolean verbose;
    @Parameter(defaultValue="true", property="failWhenNoMutations")
    private boolean failWhenNoMutations;
    @Parameter(defaultValue="true", property="timestampedReports")
    private boolean timestampedReports;
    @Parameter(property="excludedGroups")
    private ArrayList<String> excludedGroups;
    @Parameter(property="includedGroups")
    private ArrayList<String> includedGroups;
    @Parameter(property="mutationUnitSize")
    private int mutationUnitSize;
    @Parameter(defaultValue="false", property="exportLineCoverage")
    private boolean exportLineCoverage;
    @Parameter(defaultValue="0", property="mutationThreshold")
    private int mutationThreshold;
    @Parameter(defaultValue="-1", property="maxSurviving")
    private int maxSurviving;
    @Parameter(defaultValue="0", property="coverageThreshold")
    private int coverageThreshold;
    @Parameter
    private String jvm;
    @Parameter(defaultValue="gregor", property="mutationEngine")
    private String mutationEngine;
    @Parameter(property="additionalClasspathElements")
    private ArrayList<String> additionalClasspathElements;
    @Parameter(property="classpathDependencyExcludes")
    private ArrayList<String> classpathDependencyExcludes;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="true")
    private boolean parseSurefireConfig;
    @Parameter(defaultValue="false")
    private boolean skipTests;
    @Parameter(defaultValue="false", property="useSlf4j")
    private boolean useSlf4j;
    @Parameter
    private Map<String, String> pluginConfiguration;
    @Parameter
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="plugin.artifactMap", readonly=true, required=true)
    private Map<String, Artifact> pluginArtifactMap;
    protected final GoalStrategy goalStrategy;

    public AbstractPitMojo() {
        this(new RunPitStrategy(), new DependencyFilter(new PluginServices(AbstractPitMojo.class.getClassLoader())), new PluginServices(AbstractPitMojo.class.getClassLoader()));
    }

    public AbstractPitMojo(GoalStrategy strategy, Predicate<Artifact> filter, PluginServices plugins) {
        this.goalStrategy = strategy;
        this.filter = filter;
        this.plugins = plugins;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.switchLogging();
        if (this.shouldRun()) {
            for (ToolClasspathPlugin each : this.plugins.findToolClasspathPlugins()) {
                this.getLog().info((CharSequence)("Found plugin : " + each.description()));
            }
            for (ToolClasspathPlugin each : this.plugins.findClientClasspathPlugins()) {
                this.getLog().info((CharSequence)("Found shared classpath plugin : " + each.description()));
            }
            Option<CombinedStatistics> result = this.analyse();
            if (result.hasSome()) {
                this.throwErrorIfScoreBelowThreshold(((CombinedStatistics)result.value()).getMutationStatistics());
                this.throwErrorIfMoreThanMaximumSurvivors(((CombinedStatistics)result.value()).getMutationStatistics());
                this.throwErrorIfCoverageBelowThreshold(((CombinedStatistics)result.value()).getCoverageSummary());
            }
        } else {
            this.getLog().info((CharSequence)"Skipping project");
        }
    }

    private void switchLogging() {
        if (this.useSlf4j) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
            Logger.getLogger("PIT").addHandler((Handler)new SLF4JBridgeHandler());
            SysOutOverSLF4J.sendSystemOutAndErrToSLF4J();
        }
    }

    private void throwErrorIfCoverageBelowThreshold(CoverageSummary coverageSummary) throws MojoFailureException {
        if (this.coverageThreshold != 0 && coverageSummary.getCoverage() < this.coverageThreshold) {
            throw new MojoFailureException("Line coverage of " + coverageSummary.getCoverage() + "(" + coverageSummary.getNumberOfCoveredLines() + "/" + coverageSummary.getNumberOfLines() + ") is below threshold of " + this.coverageThreshold);
        }
    }

    private void throwErrorIfScoreBelowThreshold(MutationStatistics result) throws MojoFailureException {
        if (this.mutationThreshold != 0 && result.getPercentageDetected() < (long)this.mutationThreshold) {
            throw new MojoFailureException("Mutation score of " + result.getPercentageDetected() + " is below threshold of " + this.mutationThreshold);
        }
    }

    private void throwErrorIfMoreThanMaximumSurvivors(MutationStatistics result) throws MojoFailureException {
        if (this.maxSurviving > 0 && result.getTotalSurvivingMutations() > (long)this.maxSurviving) {
            throw new MojoFailureException("Had " + result.getTotalSurvivingMutations() + " surviving mutants, but only " + this.mutationThreshold + " survivors allowed");
        }
    }

    protected Option<CombinedStatistics> analyse() throws MojoExecutionException {
        ReportOptions data = new MojoToReportOptionsConverter(this, new SurefireConfigConverter(), this.filter).convert();
        return Option.some((Object)this.goalStrategy.execute(this.detectBaseDir(), data, this.plugins, this.environmentVariables));
    }

    protected File detectBaseDir() {
        MavenProject executionProject = this.project.getExecutionProject();
        if (executionProject == null) {
            return null;
        }
        return executionProject.getBasedir();
    }

    public List<String> getTargetClasses() {
        return this.targetClasses;
    }

    public List<String> getTargetTests() {
        return this.targetTests;
    }

    public List<String> getExcludedMethods() {
        return this.excludedMethods;
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public List<String> getAvoidCallsTo() {
        return this.avoidCallsTo;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public int getMaxDependencyDistance() {
        return this.maxDependencyDistance;
    }

    public int getThreads() {
        return this.threads;
    }

    public boolean isMutateStaticInitializers() {
        return this.mutateStaticInitializers;
    }

    public List<String> getMutators() {
        return this.mutators;
    }

    public float getTimeoutFactor() {
        return this.timeoutFactor;
    }

    public long getTimeoutConstant() {
        return this.timeoutConstant;
    }

    public int getMaxMutationsPerClass() {
        return this.maxMutationsPerClass;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public List<String> getOutputFormats() {
        return this.outputFormats;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Map<String, Artifact> getPluginArtifactMap() {
        return this.pluginArtifactMap;
    }

    public boolean isFailWhenNoMutations() {
        return this.failWhenNoMutations;
    }

    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    public List<String> getIncludedGroups() {
        return this.includedGroups;
    }

    public int getMutationUnitSize() {
        return this.mutationUnitSize;
    }

    public boolean isTimestampedReports() {
        return this.timestampedReports;
    }

    public boolean isDetectInlinedCode() {
        return this.detectInlinedCode;
    }

    public void setTimestampedReports(boolean timestampedReports) {
        this.timestampedReports = timestampedReports;
    }

    public File getHistoryOutputFile() {
        return this.historyOutputFile;
    }

    public File getHistoryInputFile() {
        return this.historyInputFile;
    }

    public boolean isExportLineCoverage() {
        return this.exportLineCoverage;
    }

    protected boolean shouldRun() {
        return !this.skip && !this.skipTests && !this.project.getPackaging().equalsIgnoreCase("pom");
    }

    public String getMutationEngine() {
        return this.mutationEngine;
    }

    public String getJavaExecutable() {
        return this.jvm;
    }

    public void setJavaExecutable(String javaExecutable) {
        this.jvm = javaExecutable;
    }

    public List<String> getAdditionalClasspathElements() {
        return this.additionalClasspathElements;
    }

    public List<String> getClasspathDependencyExcludes() {
        return this.classpathDependencyExcludes;
    }

    public boolean isParseSurefireConfig() {
        return this.parseSurefireConfig;
    }

    public Map<String, String> getPluginProperties() {
        return this.pluginConfiguration;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public boolean useHistory() {
        return this.withHistory;
    }
}

