package org.openqa.selenium.devtools.v139.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class DirectUDPSocketOptions {

    private final java.util.Optional<java.lang.String> remoteAddr;

    private final java.util.Optional<java.lang.Integer> remotePort;

    private final java.util.Optional<java.lang.String> localAddr;

    private final java.util.Optional<java.lang.Integer> localPort;

    private final java.util.Optional<org.openqa.selenium.devtools.v139.network.model.DirectSocketDnsQueryType> dnsQueryType;

    private final java.util.Optional<java.lang.Number> sendBufferSize;

    private final java.util.Optional<java.lang.Number> receiveBufferSize;

    public DirectUDPSocketOptions(java.util.Optional<java.lang.String> remoteAddr, java.util.Optional<java.lang.Integer> remotePort, java.util.Optional<java.lang.String> localAddr, java.util.Optional<java.lang.Integer> localPort, java.util.Optional<org.openqa.selenium.devtools.v139.network.model.DirectSocketDnsQueryType> dnsQueryType, java.util.Optional<java.lang.Number> sendBufferSize, java.util.Optional<java.lang.Number> receiveBufferSize) {
        this.remoteAddr = remoteAddr;
        this.remotePort = remotePort;
        this.localAddr = localAddr;
        this.localPort = localPort;
        this.dnsQueryType = dnsQueryType;
        this.sendBufferSize = sendBufferSize;
        this.receiveBufferSize = receiveBufferSize;
    }

    public java.util.Optional<java.lang.String> getRemoteAddr() {
        return remoteAddr;
    }

    /**
     * Unsigned int 16.
     */
    public java.util.Optional<java.lang.Integer> getRemotePort() {
        return remotePort;
    }

    public java.util.Optional<java.lang.String> getLocalAddr() {
        return localAddr;
    }

    /**
     * Unsigned int 16.
     */
    public java.util.Optional<java.lang.Integer> getLocalPort() {
        return localPort;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v139.network.model.DirectSocketDnsQueryType> getDnsQueryType() {
        return dnsQueryType;
    }

    /**
     * Expected to be unsigned integer.
     */
    public java.util.Optional<java.lang.Number> getSendBufferSize() {
        return sendBufferSize;
    }

    /**
     * Expected to be unsigned integer.
     */
    public java.util.Optional<java.lang.Number> getReceiveBufferSize() {
        return receiveBufferSize;
    }

    private static DirectUDPSocketOptions fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> remoteAddr = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> remotePort = java.util.Optional.empty();
        java.util.Optional<java.lang.String> localAddr = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> localPort = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v139.network.model.DirectSocketDnsQueryType> dnsQueryType = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> sendBufferSize = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> receiveBufferSize = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "remoteAddr":
                    remoteAddr = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "remotePort":
                    remotePort = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "localAddr":
                    localAddr = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "localPort":
                    localPort = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "dnsQueryType":
                    dnsQueryType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v139.network.model.DirectSocketDnsQueryType.class));
                    break;
                case "sendBufferSize":
                    sendBufferSize = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "receiveBufferSize":
                    receiveBufferSize = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DirectUDPSocketOptions(remoteAddr, remotePort, localAddr, localPort, dnsQueryType, sendBufferSize, receiveBufferSize);
    }
}
