package org.openqa.selenium.devtools.v140.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum UserReidentificationIssueType {

    BLOCKEDFRAMENAVIGATION("BlockedFrameNavigation"), BLOCKEDSUBRESOURCE("BlockedSubresource");

    private String value;

    UserReidentificationIssueType(String value) {
        this.value = value;
    }

    public static UserReidentificationIssueType fromString(String s) {
        return java.util.Arrays.stream(UserReidentificationIssueType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within UserReidentificationIssueType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static UserReidentificationIssueType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
