package org.openqa.selenium.devtools.v141.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Used to specify sensor types to emulate.
 * See https://w3c.github.io/sensors/#automation for more information.
 */
@org.openqa.selenium.Beta()
public enum SensorType {

    ABSOLUTE_ORIENTATION("absolute-orientation"),
    ACCELEROMETER("accelerometer"),
    AMBIENT_LIGHT("ambient-light"),
    GRAVITY("gravity"),
    GYROSCOPE("gyroscope"),
    LINEAR_ACCELERATION("linear-acceleration"),
    MAGNETOMETER("magnetometer"),
    RELATIVE_ORIENTATION("relative-orientation");

    private String value;

    SensorType(String value) {
        this.value = value;
    }

    public static SensorType fromString(String s) {
        return java.util.Arrays.stream(SensorType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SensorType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SensorType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
