/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v141.pwa.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v141.pwa.model.FileHandlerAccept;
import org.openqa.selenium.json.JsonInput;

public class FileHandler {
    private final String action;
    private final List<FileHandlerAccept> accepts;
    private final String displayName;

    public FileHandler(String action, List<FileHandlerAccept> accepts, String displayName) {
        this.action = Objects.requireNonNull(action, "action is required");
        this.accepts = Objects.requireNonNull(accepts, "accepts is required");
        this.displayName = Objects.requireNonNull(displayName, "displayName is required");
    }

    public String getAction() {
        return this.action;
    }

    public List<FileHandlerAccept> getAccepts() {
        return this.accepts;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private static FileHandler fromJson(JsonInput input) {
        String action = null;
        List accepts = null;
        String displayName = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "action": {
                    action = input.nextString();
                    continue block10;
                }
                case "accepts": {
                    accepts = input.readArray(FileHandlerAccept.class);
                    continue block10;
                }
                case "displayName": {
                    displayName = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FileHandler(action, accepts, displayName);
    }
}

