/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.spockframework.runtime.IFeatureSortOrder;
import org.spockframework.runtime.SpecUtil;
import org.spockframework.runtime.model.BlockInfo;
import org.spockframework.runtime.model.BlockMetadata;
import org.spockframework.runtime.model.DataProviderInfo;
import org.spockframework.runtime.model.DataProviderMetadata;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FeatureMetadata;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.FieldMetadata;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.SpecMetadata;
import org.spockframework.util.InternalIdentifiers;
import spock.lang.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecInfoBuilder {
    private final Class<?> clazz;
    private final SpecInfo spec = new SpecInfo();

    public SpecInfoBuilder(Class<?> clazz) {
        this.clazz = clazz;
    }

    public SpecInfo build() {
        this.doBuild();
        int order = 0;
        for (SpecInfo curr : this.spec.getSpecsTopToBottom()) {
            for (FeatureInfo feature : curr.getFeatures()) {
                feature.setDeclarationOrder(order);
                feature.setExecutionOrder(order);
                ++order;
            }
        }
        return this.spec;
    }

    private SpecInfo doBuild() {
        this.buildSuperSpec();
        this.buildSpec();
        this.buildFields();
        this.buildFeatures();
        this.buildInitializerMethods();
        this.buildFixtureMethods();
        return this.spec;
    }

    private void buildSuperSpec() {
        Class<?> superClass = this.clazz.getSuperclass();
        if (superClass == Object.class || superClass == Specification.class) {
            return;
        }
        SpecInfo superSpec = new SpecInfoBuilder(superClass).doBuild();
        this.spec.setSuperSpec(superSpec);
        superSpec.setSubSpec(this.spec);
    }

    private void buildSpec() {
        SpecUtil.checkIsSpec(this.clazz);
        SpecMetadata metadata = this.clazz.getAnnotation(SpecMetadata.class);
        this.spec.setParent(null);
        this.spec.setName(this.clazz.getSimpleName());
        this.spec.setLine(metadata.line());
        this.spec.setReflection(this.clazz);
        this.spec.setFilename(metadata.filename());
    }

    private void buildFields() {
        for (Field field : this.clazz.getDeclaredFields()) {
            FieldMetadata metadata = field.getAnnotation(FieldMetadata.class);
            if (metadata == null) continue;
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setParent(this.spec);
            fieldInfo.setReflection(field);
            fieldInfo.setName(metadata.name());
            fieldInfo.setOrdinal(metadata.ordinal());
            fieldInfo.setLine(metadata.line());
            this.spec.addField(fieldInfo);
        }
        Collections.sort(this.spec.getFields(), new Comparator<FieldInfo>(){

            @Override
            public int compare(FieldInfo f1, FieldInfo f2) {
                return f1.getOrdinal() - f2.getOrdinal();
            }
        });
    }

    private void buildFeatures() {
        for (Method method : this.clazz.getDeclaredMethods()) {
            FeatureMetadata metadata = method.getAnnotation(FeatureMetadata.class);
            if (metadata == null) continue;
            method.setAccessible(true);
            this.spec.addFeature(this.createFeature(method, metadata));
        }
        Collections.sort(this.spec.getFeatures(), new IFeatureSortOrder(){

            public int compare(FeatureInfo m1, FeatureInfo m2) {
                return m1.getDeclarationOrder() - m2.getDeclarationOrder();
            }
        });
    }

    private FeatureInfo createFeature(Method method, FeatureMetadata featureMetadata) {
        FeatureInfo feature = new FeatureInfo();
        feature.setParent(this.spec);
        feature.setName(featureMetadata.name());
        feature.setLine(featureMetadata.line());
        feature.setDeclarationOrder(featureMetadata.ordinal());
        for (String name : featureMetadata.parameterNames()) {
            feature.addParameterName(name);
        }
        MethodInfo featureMethod = new MethodInfo();
        featureMethod.setParent(this.spec);
        featureMethod.setName(featureMetadata.name());
        featureMethod.setLine(featureMetadata.line());
        featureMethod.setFeature(feature);
        featureMethod.setReflection(method);
        featureMethod.setKind(MethodKind.FEATURE);
        feature.setFeatureMethod(featureMethod);
        String processorMethodName = InternalIdentifiers.getDataProcessorName(method.getName());
        MethodInfo dataProcessorMethod = this.createMethod(processorMethodName, MethodKind.DATA_PROCESSOR, false);
        if (dataProcessorMethod != null) {
            feature.setDataProcessorMethod(dataProcessorMethod);
            int providerCount = 0;
            String providerMethodName = InternalIdentifiers.getDataProviderName(method.getName(), providerCount++);
            MethodInfo providerMethod = this.createMethod(providerMethodName, MethodKind.DATA_PROVIDER, false);
            while (providerMethod != null) {
                feature.addDataProvider(this.createDataProvider(feature, providerMethod));
                providerMethodName = InternalIdentifiers.getDataProviderName(method.getName(), providerCount++);
                providerMethod = this.createMethod(providerMethodName, MethodKind.DATA_PROVIDER, false);
            }
        }
        for (BlockMetadata blockMetadata : featureMetadata.blocks()) {
            BlockInfo block = new BlockInfo();
            block.setKind(blockMetadata.kind());
            block.setTexts(Arrays.asList(blockMetadata.texts()));
            feature.addBlock(block);
        }
        return feature;
    }

    private DataProviderInfo createDataProvider(FeatureInfo feature, MethodInfo method) {
        DataProviderMetadata metadata = ((Method)method.getReflection()).getAnnotation(DataProviderMetadata.class);
        DataProviderInfo provider = new DataProviderInfo();
        provider.setParent(feature);
        provider.setLine(metadata.line());
        provider.setDataVariables(Arrays.asList(metadata.dataVariables()));
        provider.setDataProviderMethod(method);
        return provider;
    }

    private MethodInfo createMethod(String name, MethodKind kind, boolean allowStub) {
        Method reflection = this.findMethod(name);
        if (reflection == null && !allowStub) {
            return null;
        }
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setParent(this.spec);
        methodInfo.setName(name);
        methodInfo.setReflection(reflection);
        methodInfo.setKind(kind);
        return methodInfo;
    }

    private Method findMethod(String name) {
        for (Method method : ((Class)this.spec.getReflection()).getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    private void buildInitializerMethods() {
        this.spec.setInitializerMethod(this.createMethod("$spock_initializeFields", MethodKind.INITIALIZER, true));
        this.spec.setSharedInitializerMethod(this.createMethod("$spock_initializeSharedFields", MethodKind.SHARED_INITIALIZER, true));
    }

    private void buildFixtureMethods() {
        this.spec.setSetupMethod(this.createMethod("setup", MethodKind.SETUP, true));
        this.spec.setCleanupMethod(this.createMethod("cleanup", MethodKind.CLEANUP, true));
        this.spec.setSetupSpecMethod(this.createMethod("setupSpec", MethodKind.SETUP_SPEC, true));
        this.spec.setCleanupSpecMethod(this.createMethod("cleanupSpec", MethodKind.CLEANUP_SPEC, true));
    }
}

