/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.annotation.Annotation;
import java.util.List;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.extension.AbstractAnnotationDrivenExtension;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;

public class StepwiseExtension
extends AbstractAnnotationDrivenExtension {
    public void visitSpecAnnotation(Annotation annotation, SpecInfo spec) {
        this.sortFeaturesInDeclarationOrder(spec);
        this.includeFeaturesBeforeLastIncludedFeature(spec);
        this.skipFeaturesAfterFirstFailingFeature(spec);
    }

    private void sortFeaturesInDeclarationOrder(SpecInfo spec) {
        for (FeatureInfo feature : spec.getFeatures()) {
            feature.setExecutionOrder(feature.getDeclarationOrder());
        }
    }

    private void includeFeaturesBeforeLastIncludedFeature(SpecInfo spec) {
        List<FeatureInfo> features = spec.getFeatures();
        boolean includeRemaining = false;
        for (int i = features.size() - 1; i >= 0; --i) {
            FeatureInfo feature = features.get(i);
            if (includeRemaining) {
                feature.setExcluded(false);
                continue;
            }
            if (feature.isExcluded()) continue;
            includeRemaining = true;
        }
    }

    private void skipFeaturesAfterFirstFailingFeature(final SpecInfo spec) {
        spec.getBottomSpec().addListener(new AbstractRunListener(){

            public void error(ErrorInfo error) {
                if (!((SpecInfo)error.getMethod().getParent()).equals(spec)) {
                    return;
                }
                for (FeatureInfo feature : spec.getFeatures()) {
                    feature.setSkipped(true);
                }
            }
        });
    }
}

