/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import java.util.Locale;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.observation.ServerHttpObservationDocumentation;
import org.springframework.http.server.reactive.observation.ServerRequestObservationContext;
import org.springframework.http.server.reactive.observation.ServerRequestObservationConvention;
import org.springframework.util.StringUtils;

public class DefaultServerRequestObservationConvention
implements ServerRequestObservationConvention {
    private static final String DEFAULT_NAME = "http.server.requests";
    private static final KeyValue METHOD_UNKNOWN = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, (String)"UNKNOWN");
    private static final KeyValue STATUS_UNKNOWN = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)"UNKNOWN");
    private static final KeyValue HTTP_OUTCOME_SUCCESS = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)"SUCCESS");
    private static final KeyValue HTTP_OUTCOME_UNKNOWN = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)"UNKNOWN");
    private static final KeyValue URI_UNKNOWN = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)"UNKNOWN");
    private static final KeyValue URI_ROOT = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)"root");
    private static final KeyValue URI_NOT_FOUND = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)"NOT_FOUND");
    private static final KeyValue URI_REDIRECTION = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)"REDIRECTION");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)"none");
    private static final KeyValue HTTP_URL_UNKNOWN = KeyValue.of((KeyName)ServerHttpObservationDocumentation.HighCardinalityKeyNames.HTTP_URL, (String)"UNKNOWN");
    private static final Set<HttpMethod> HTTP_METHODS = Set.of(HttpMethod.values());
    private final String name;

    public DefaultServerRequestObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultServerRequestObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getContextualName(ServerRequestObservationContext context) {
        String httpMethod = ((ServerHttpRequest)context.getCarrier()).getMethod().name().toLowerCase(Locale.ROOT);
        if (context.getPathPattern() != null) {
            return "http " + httpMethod + " " + context.getPathPattern();
        }
        return "http " + httpMethod;
    }

    public KeyValues getLowCardinalityKeyValues(ServerRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.exception(context), this.method(context), this.outcome(context), this.status(context), this.uri(context)});
    }

    public KeyValues getHighCardinalityKeyValues(ServerRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.httpUrl(context)});
    }

    protected KeyValue method(ServerRequestObservationContext context) {
        HttpMethod method;
        if (context.getCarrier() != null && HTTP_METHODS.contains(method = ((ServerHttpRequest)context.getCarrier()).getMethod())) {
            return KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, (String)method.name());
        }
        return METHOD_UNKNOWN;
    }

    protected KeyValue status(ServerRequestObservationContext context) {
        if (context.isConnectionAborted() && (context.getResponse() == null || !((ServerHttpResponse)context.getResponse()).isCommitted())) {
            return STATUS_UNKNOWN;
        }
        return context.getResponse() != null && ((ServerHttpResponse)context.getResponse()).getStatusCode() != null ? KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)Integer.toString(((ServerHttpResponse)context.getResponse()).getStatusCode().value())) : STATUS_UNKNOWN;
    }

    protected KeyValue uri(ServerRequestObservationContext context) {
        if (context.getCarrier() != null) {
            HttpStatus status;
            String pattern = context.getPathPattern();
            if (pattern != null) {
                if (pattern.isEmpty()) {
                    return URI_ROOT;
                }
                return KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)pattern);
            }
            if (context.getResponse() != null && ((ServerHttpResponse)context.getResponse()).getStatusCode() != null && (status = HttpStatus.resolve(((ServerHttpResponse)context.getResponse()).getStatusCode().value())) != null) {
                if (status.is3xxRedirection()) {
                    return URI_REDIRECTION;
                }
                if (status == HttpStatus.NOT_FOUND) {
                    return URI_NOT_FOUND;
                }
            }
        }
        return URI_UNKNOWN;
    }

    protected KeyValue exception(ServerRequestObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            String simpleName = error.getClass().getSimpleName();
            return KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)(StringUtils.hasText((String)simpleName) ? simpleName : error.getClass().getName()));
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue outcome(ServerRequestObservationContext context) {
        if (context.isConnectionAborted()) {
            return HTTP_OUTCOME_UNKNOWN;
        }
        if (context.getResponse() != null && ((ServerHttpResponse)context.getResponse()).getStatusCode() != null) {
            return HttpOutcome.forStatus(((ServerHttpResponse)context.getResponse()).getStatusCode());
        }
        return HTTP_OUTCOME_UNKNOWN;
    }

    protected KeyValue httpUrl(ServerRequestObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of((KeyName)ServerHttpObservationDocumentation.HighCardinalityKeyNames.HTTP_URL, (String)((ServerHttpRequest)context.getCarrier()).getPath().toString());
        }
        return HTTP_URL_UNKNOWN;
    }

    static class HttpOutcome {
        HttpOutcome() {
        }

        static KeyValue forStatus(HttpStatusCode statusCode) {
            if (statusCode.is2xxSuccessful()) {
                return HTTP_OUTCOME_SUCCESS;
            }
            if (statusCode instanceof HttpStatus) {
                HttpStatus status = (HttpStatus)statusCode;
                return KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)status.series().name());
            }
            return HTTP_OUTCOME_UNKNOWN;
        }
    }
}

